package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;

import com.zoyi.channel.plugin.android.deserializer.*;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.NestedMessage;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class ParseUtils {

  @Nullable
  private static Gson gson;

  public static Gson getCustomGson() {
    if (gson == null) {
      GsonBuilder builder = new GsonBuilder();
      builder.registerTypeAdapter(Message.class, new MessageDeserializer());
      builder.registerTypeAdapter(NestedMessage.class, new NestedMessageDeserializer());
      builder.registerTypeAdapter(TranslationRepo.class, new TranslationRepoDeserializer());

      gson = builder.create();
    }

    return gson;
  }

  @Nullable
  public static<T> T parseJson(String entity, Class<T> target) {
    try {
      return getCustomGson().fromJson(entity, target);
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
    return null;
  }

  @Nullable
  public static String parsePhoneNumber(Context context, @Nullable String phoneNumber) {
    try {
      PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();

      Integer simCountryCode = Optional.ofNullable(context.getSystemService(Context.TELEPHONY_SERVICE))
          .map(service -> (TelephonyManager) service)
          .map(TelephonyManager::getSimCountryIso)
          .map(String::toUpperCase)
          .map(phoneNumberUtil::getCountryCodeForRegion)
          .filter(it -> it != 0)
          .orElse(null);

      return Optional.ofNullable(phoneNumberUtil.parse(phoneNumber, "ZZ"))
          .filter(number -> number.hasCountryCode() && simCountryCode != null && number.getCountryCode() == simCountryCode)
          .map(number -> phoneNumberUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.NATIONAL))
          .orElse(phoneNumber);

    } catch (Exception ex) {
      return phoneNumber;
    }
  }
}
