package com.zoyi.channel.plugin.android.activity.language;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.UserStore;

public class LanguageSettingsPresenter
    extends AbstractPresenter<LanguageSettingsContract.View>
    implements LanguageSettingsContract.Presenter {

  public LanguageSettingsPresenter(LanguageSettingsContract.View view) {
    super(view);
  }

  @Override
  public void init() {
  }

  @Override
  public void changeLocale(CHLocale locale) {
    view.showProgress(locale);
    UserAction.updateLanguage(
        locale.toString(),
        user -> {
          view.hideProgress();

          UserStore.get().user.set(user);
          SettingsStore.get().locale.set(locale);

          view.onLanguageChange(locale);
        },
        s -> view.hideProgress()
    );
  }
}
