/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.channel.plugin.android.util.Initializer;

public class FileRowTextView
extends FrameLayout {
    private TextView textFileName;
    private TextView textFileSize;
    private TextView textFileCount;

    public FileRowTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public FileRowTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public FileRowTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_file_row_text, (ViewGroup)this, true);
        AppCompatImageView imageFileClip = (AppCompatImageView)root.findViewById(R.id.ch_imageFileClip);
        this.textFileName = (TextView)root.findViewById(R.id.ch_textFileName);
        this.textFileSize = (TextView)root.findViewById(R.id.ch_textFileSize);
        this.textFileCount = (TextView)root.findViewById(R.id.ch_textFileCount);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FileRowTextView, 0, 0);
            try {
                int iconSize = typedArray.getDimensionPixelSize(R.styleable.FileRowTextView_ch_cfr_iconSize, this.getResources().getDimensionPixelSize(R.dimen.ch_file_row_text_image_default_size));
                int textSizeFileName = typedArray.getDimensionPixelSize(R.styleable.FileRowTextView_ch_cfr_fileNameTextSize, this.getResources().getDimensionPixelSize(R.dimen.ch_file_row_text_name_default_size));
                int textSizeFileSize = typedArray.getDimensionPixelSize(R.styleable.FileRowTextView_ch_cfr_fileSizeTextSize, this.getResources().getDimensionPixelSize(R.dimen.ch_file_row_text_size_default_size));
                int textSizeFileCount = typedArray.getDimensionPixelSize(R.styleable.FileRowTextView_ch_cfr_fileCountTextSize, this.getResources().getDimensionPixelSize(R.dimen.ch_file_row_text_count_default_size));
                boolean useOnlyName = typedArray.getBoolean(R.styleable.FileRowTextView_ch_cfr_useOnlyName, false);
                ViewGroup.LayoutParams layoutParams = imageFileClip.getLayoutParams();
                layoutParams.width = iconSize;
                layoutParams.height = iconSize;
                imageFileClip.setLayoutParams(layoutParams);
                this.textFileName.setTextSize(0, (float)textSizeFileName);
                this.textFileSize.setTextSize(0, (float)textSizeFileSize);
                this.textFileCount.setTextSize(0, (float)textSizeFileCount);
                if (useOnlyName) {
                    this.textFileSize.setVisibility(8);
                    this.textFileCount.setVisibility(8);
                }
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setFile(File file, int count) {
        this.textFileName.setText((CharSequence)file.getName());
        this.textFileSize.setText((CharSequence)("(" + FormatUtils.formatFileSize(file.getSize()) + ")"));
        if (count > 1) {
            this.textFileCount.setVisibility(0);
            this.textFileCount.setText((CharSequence)("+" + (count - 1)));
        } else {
            this.textFileCount.setVisibility(8);
        }
    }
}

