package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.deserializer.*;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.NestedMessage;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class ParseUtils {

  @Nullable
  private static Gson gson;

  public static Gson getCustomGson() {
    if (gson == null) {
      GsonBuilder builder = new GsonBuilder();
      builder.registerTypeAdapter(Message.class, new MessageDeserializer());
      builder.registerTypeAdapter(NestedMessage.class, new NestedMessageDeserializer());
      builder.registerTypeAdapter(TranslationRepo.class, new TranslationRepoDeserializer());

      gson = builder.create();
    }

    return gson;
  }

  @Nullable
  public static<T> T parseJson(String entity, Class<T> target) {
    try {
      return getCustomGson().fromJson(entity, target);
    } catch (Exception ex) {
      L.e(ex.getMessage());
    }
    return null;
  }
}
