package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

/**
 * Created by mika on 2018. 10. 26..
 */

class Step {

  @Nullable
  private NestedMessage message;

  @Nullable
  List<Block> getBlocks() {
    return Optional.ofNullable(message)
        .map(NestedMessage::getBlocks)
        .orElse(null);
  }

  @Nullable
  String getPlainText() {
    return Optional.ofNullable(message)
        .map(NestedMessage::getPlainText)
        .orElse(null);
  }

  @Nullable
  List<File> getFiles() {
    return Optional.ofNullable(message)
        .map(NestedMessage::getFiles)
        .orElse(null);
  }

  @Nullable
  WebPage getWebPage() {
    return Optional.ofNullable(message)
        .map(NestedMessage::getWebPage)
        .orElse(null);
  }
}
