package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.gson.Gson;

import java.util.Locale;

/**
 * Created by mika on 2017. 1. 16..
 */
public class PrefSupervisor {

  private static final String VEIL_ID = "X-Veil-Id";
  private static final String DEVICE_TOKEN = "Device-Token";
  private static final String SENT_DEVICE_TOKEN = "Sent-Device-Token";
  private static final String DEVICE_ID = "Device-Id";
  private static final String PUSH_CHAT_ID = "Push-Chat-Id";
  private static final String SHOW_CLOSED_CHAT = "Show-Closed-Chat-V2";
  private static final String ENABLE_PUSH_ALARM = "Enable-Push-Alarm";
  private static final String PLUGIN_SETTINGS = "Plugin-Settings";
  private static final String PLUGIN_LANGUAGE = "Plugin-language";
  private static final String ENABLE_TRANSLATE_MESSAGE = "Enable-Translate-Message";
  private static final String JWT_TOKEN = "Jwt_Token";
  private static final String BOOT_FLAG = "Boot-Flag";
  private static final String BOOT_DATA_PERSON_ID = "Boot-Data-Person-Id";

  private static SharedPreferences getPreferences(Context context) {
    return context.getSharedPreferences("CHANNEL_PLUGIN_PRIVATE_DATA", 0);
  }

  @Nullable
  public static String getVeilId(@Nullable Context context) {
    if (context != null) {
      return getPreferences(context).getString(VEIL_ID, null);
    }
    return null;
  }

  public static void setVeilId(@Nullable Context context, @Nullable String veilId) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.remove(VEIL_ID);
      editor.putString(VEIL_ID, veilId);
      editor.apply();
    }
  }

  public static void setDeviceToken(Context context, String token) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(DEVICE_TOKEN, token);
    editor.apply();
  }

  public static void setSentDeviceToken(Context context, @Nullable String token) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(SENT_DEVICE_TOKEN, token);
    editor.apply();
  }

  public static String getDeviceToken(Context context) {
    return getPreferences(context).getString(DEVICE_TOKEN, null);
  }

  public static String getSentDeviceToken(Context context) {
    return getPreferences(context).getString(SENT_DEVICE_TOKEN, null);
  }

  public static void setDeviceId(Context context, String deviceId) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(DEVICE_ID, deviceId);
    editor.apply();
  }

  public static String getDeviceId(Context context) {
    return getPreferences(context).getString(DEVICE_ID, null);
  }

  public static void setPushChatId(Context context, String chatId) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(PUSH_CHAT_ID, chatId);
    editor.apply();
  }

  public static void clearPushChatId(Context context) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putString(PUSH_CHAT_ID, null);
    editor.apply();
  }

  public static String getPushChatId(Context context) {
    return getPreferences(context).getString(PUSH_CHAT_ID, null);
  }

  public static boolean hasPushChatId(Context context) {
    return !TextUtils.isEmpty(getPushChatId(context));
  }

  public static void setShowClosedChat(Context context, boolean show) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putBoolean(SHOW_CLOSED_CHAT, show);
    editor.apply();
  }

  public static boolean isShownClosedChat(Context context) {
    return getPreferences(context).getBoolean(SHOW_CLOSED_CHAT, true);
  }

  public static void setPushAlarm(Context context, boolean enabled) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putBoolean(ENABLE_PUSH_ALARM, enabled);
    editor.apply();
  }

  public static boolean isEnabledPushAlarm(Context context) {
    return getPreferences(context).getBoolean(ENABLE_PUSH_ALARM, true);
  }

  public static void setPluginSetting(Context context, ChannelPluginSettings pluginSetting) {
    SharedPreferences.Editor editor = getPreferences(context).edit();
    Gson gson = new Gson();

    String setting = gson.toJson(pluginSetting);
    editor.putString(PLUGIN_SETTINGS, setting);
    editor.apply();
  }

  public static ChannelPluginSettings getPluginSetting(Context context) {
    Gson gson = new Gson();

    String setting = getPreferences(context).getString(PLUGIN_SETTINGS, null);

    return gson.fromJson(setting, ChannelPluginSettings.class);
  }

  public static void setJwtToken(@Nullable Context context, @Nullable String jwtToken) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.putString(JWT_TOKEN, jwtToken);
      editor.apply();
    }
  }

  @Nullable
  public static String getJwt(@Nullable Context context) {
    if (context == null) {
      return null;
    }
    return getPreferences(context).getString(JWT_TOKEN, null);
  }

  public static void setTranslateOption(Context context, boolean enable) {
    SharedPreferences.Editor editor = getPreferences(context).edit();

    editor.putBoolean(ENABLE_TRANSLATE_MESSAGE, enable);
    editor.apply();
  }

  public static boolean canTranslateMessage(Context context) {
    return getPreferences(context).getBoolean(ENABLE_TRANSLATE_MESSAGE, true);
  }

  public static boolean hasBootFlag(@Nullable Context context) {
    if (context != null) {
      return getPreferences(context).getBoolean(BOOT_FLAG, false);
    }
    return false;
  }

  @Nullable
  public static String getUserId(@Nullable Context context) {
    if (context != null) {
      return getPreferences(context).getString(BOOT_DATA_PERSON_ID, null);
    }
    return null;
  }

  public static void setBootData(@Nullable Context context, @Nullable User user) {
    if (context != null && user != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.putBoolean(BOOT_FLAG, true);
      editor.putString(BOOT_DATA_PERSON_ID, user.getPersonId());
      editor.apply();
    }
  }

  public static void clearBootData(@Nullable Context context) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      editor.putBoolean(BOOT_FLAG, false);
      editor.putString(BOOT_DATA_PERSON_ID, null);
      editor.apply();
    }
  }
}
