/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.ui.utils;

import android.animation.Animator;
import android.view.View;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;

public class FadeViewHelper
implements YouTubePlayerListener {
    public static final long DEFAULT_ANIMATION_DURATION = 300L;
    public static final long DEFAULT_FADE_OUT_DELAY = 3000L;
    private View targetView;
    private boolean isPlaying = false;
    private boolean canFade = false;
    private boolean isVisible = true;
    private Runnable fadeOut = () -> this.fade(0.0f);
    private boolean isDisabled = false;
    private long animationDuration = 300L;
    private long fadeOutDelay = 3000L;

    public FadeViewHelper(View targetView) {
        this.targetView = targetView;
    }

    public void toggleVisibility() {
        this.fade(this.isVisible ? 0.0f : 1.0f);
    }

    private void fade(final float finalAlpha) {
        if (!this.canFade || this.isDisabled) {
            return;
        }
        boolean bl = this.isVisible = finalAlpha != 0.0f;
        if (finalAlpha == 1.0f && this.isPlaying) {
            if (this.targetView.getHandler() != null) {
                this.targetView.getHandler().postDelayed(this.fadeOut, this.fadeOutDelay);
            }
        } else if (this.targetView.getHandler() != null) {
            this.targetView.getHandler().removeCallbacks(this.fadeOut);
        }
        this.targetView.animate().alpha(finalAlpha).setDuration(this.animationDuration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                if (finalAlpha == 1.0f) {
                    FadeViewHelper.this.targetView.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (finalAlpha == 0.0f) {
                    FadeViewHelper.this.targetView.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    private void updateState(PlayerConstants.PlayerState state) {
        switch (state) {
            case ENDED: 
            case PAUSED: {
                this.isPlaying = false;
                break;
            }
            case PLAYING: {
                this.isPlaying = true;
                break;
            }
        }
    }

    @Override
    public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
        this.updateState(state);
        switch (state) {
            case PAUSED: 
            case PLAYING: 
            case VIDEO_CUED: {
                this.canFade = true;
                if (state == PlayerConstants.PlayerState.PLAYING) {
                    if (this.targetView.getHandler() == null) break;
                    this.targetView.getHandler().postDelayed(this.fadeOut, this.fadeOutDelay);
                    break;
                }
                if (this.targetView.getHandler() == null) break;
                this.targetView.getHandler().removeCallbacks(this.fadeOut);
                break;
            }
            case UNSTARTED: 
            case BUFFERING: {
                this.fade(1.0f);
                this.canFade = false;
                break;
            }
            case ENDED: 
            case UNKNOWN: {
                this.fade(1.0f);
            }
        }
    }

    @Override
    public void onReady(YouTubePlayer youTubePlayer) {
    }

    @Override
    public void onPlaybackQualityChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {
    }

    @Override
    public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
    }

    @Override
    public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
    }

    @Override
    public void onVideoLoadedFraction(YouTubePlayer youTubePlayer, float loadedFraction) {
    }

    @Override
    public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
    }

    @Override
    public void onApiChange(YouTubePlayer youTubePlayer) {
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }
}

