/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.base;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.AnimRes;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action1;

public abstract class BaseActivity2
extends AppCompatActivity
implements BaseView {
    @Nullable
    private Binder pluginBinder;
    @Nullable
    private Subscription actionSubscription;
    @Nullable
    private BasePresenter presenter;
    private Transition outTransition = Transition.SLIDE_FROM_RIGHT;
    @ColorInt
    private int backColor = -16777216;
    private boolean backColorFixed = false;
    @Nullable
    private Dialog dialog;

    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.finish();
            return;
        }
        if (this.onCreate()) {
            this.handlePluginStyle();
            this.actionSubscription = Action.observable().subscribe(actionType -> {
                if (actionType == ActionType.SHUTDOWN) {
                    this.finish(Transition.NONE);
                }
            });
        } else {
            this.finish();
        }
    }

    protected void onDestroy() {
        if (this.pluginBinder != null) {
            this.pluginBinder.unbind();
            this.pluginBinder = null;
        }
        if (this.presenter != null) {
            this.presenter.release();
            this.presenter = null;
        }
        if (this.actionSubscription != null) {
            if (!this.actionSubscription.isUnsubscribed()) {
                this.actionSubscription.unsubscribe();
            }
            this.actionSubscription = null;
        }
        super.onDestroy();
    }

    protected void bindPresenter(BasePresenter presenter) {
        this.presenter = presenter;
        this.presenter.init();
    }

    private void handlePluginStyle() {
        if (!this.backColorFixed) {
            this.pluginBinder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
                if (plugin != null && !this.backColorFixed) {
                    this.setStatusBarColor(0, plugin.getTextColor() == -16777216);
                }
            }));
        }
    }

    protected void init(@LayoutRes int layoutResId) {
        this.setContentView(layoutResId);
    }

    protected void init(@LayoutRes int layoutResId, @ColorInt int backColor, boolean lightMode) {
        this.init(layoutResId);
        this.backColor = backColor;
        this.backColorFixed = true;
        this.setStatusBarColor(backColor, lightMode);
    }

    private void setStatusBarColor(@ColorInt int backColor, boolean lightMode) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                this.getWindow().setStatusBarColor(backColor);
                int systemUiVisibility = this.getWindow().getDecorView().getSystemUiVisibility();
                if (lightMode) {
                    this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility | 0x2000);
                } else {
                    this.getWindow().getDecorView().setSystemUiVisibility(systemUiVisibility & 0xFFFFDFFF);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract boolean onCreate();

    public void setOutTransition(Transition outTransition) {
        this.outTransition = outTransition;
    }

    @Override
    public void finish() {
        super.finish();
        this.overridePendingTransition(this.getEnterAnimOfFinish(), this.getExistAnimOfFinish());
    }

    @Override
    public void finish(Transition transition) {
        this.outTransition = transition;
        this.finish();
    }

    @Override
    public void finish(int resultCode) {
        this.setResult(resultCode);
        this.finish();
    }

    @Override
    public void finish(int resultCode, Transition transition) {
        this.setResult(resultCode);
        this.outTransition = transition;
        this.finish();
    }

    @AnimRes
    private int getEnterAnimOfFinish() {
        return R.anim.ch_plugin_idle;
    }

    @AnimRes
    private int getExistAnimOfFinish() {
        switch (this.outTransition) {
            case NONE: {
                return R.anim.ch_plugin_idle;
            }
            case SLIDE_FROM_BOTTOM: {
                return R.anim.ch_plugin_slide_out_bottom;
            }
        }
        return R.anim.ch_plugin_slide_out_right;
    }

    @Nullable
    public String getString(String key) {
        Intent intent = this.getIntent();
        if (intent != null) {
            return intent.getStringExtra(key);
        }
        return null;
    }

    @Override
    public void showProgress() {
        this.showProgress(ResUtils.getString((Context)this, "ch.settings.changing_message"));
    }

    @Override
    public void showProgress(String message) {
        this.hideProgress();
        this.dialog = ProgressHelper.show((Context)this, message, false);
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }
}

