package com.zoyi.channel.plugin.android.model.source.photopicker;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;

import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.io.File;
import java.util.ArrayList;

public class PhotoDataSource {

  public void getPhotoItems(final Context context, Subscriber<ArrayList<PhotoItem>> subscriber) {
    Observable.defer(
        () -> Observable.just(getPhotoItems(context)))
        .subscribeOn(Schedulers.newThread())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(subscriber);
  }

  private ArrayList<PhotoItem> getPhotoItems(Context context) {
    ArrayList<PhotoItem> photoItems = new ArrayList<>();
    String[] projection = new String[] {
        MediaStore.Files.FileColumns._ID,
        MediaStore.Files.FileColumns.DISPLAY_NAME,
        MediaStore.Files.FileColumns.MEDIA_TYPE,
        MediaStore.Files.FileColumns.SIZE
    };

    String selection = MediaStore.Files.FileColumns.MEDIA_TYPE + "="
        + MediaStore.Files.FileColumns.MEDIA_TYPE_IMAGE
        + " OR "
        + MediaStore.Files.FileColumns.MEDIA_TYPE + "="
        + MediaStore.Files.FileColumns.MEDIA_TYPE_VIDEO;

    Cursor cursor = context.getContentResolver().query(
        MediaStore.Files.getContentUri("external"),
        projection,
        selection,
        null,
        MediaStore.Files.FileColumns.DATE_ADDED);

    if (cursor == null) {
      return photoItems;
    }

    int index = 0;

    if (cursor.moveToLast()) {
      do {
        try {
          long id = cursor.getLong(cursor.getColumnIndex(projection[0]));
          String name = cursor.getString(cursor.getColumnIndex(projection[1]));
          int type = cursor.getInt(cursor.getColumnIndex(projection[2]));
          long size = cursor.getLong(cursor.getColumnIndex(projection[3]));

          Uri contentUri = Uri.withAppendedPath(getContentUri(type), String.valueOf(id));

          if (size > 0) {
            photoItems.add(new PhotoItem(id, name, contentUri, size));
          }
        } catch (Exception ex) {
        }
      } while (cursor.moveToPrevious());
    }
    cursor.close();

    return photoItems;
  }

  private Uri getContentUri(int type) {
    switch (type) {
      case MediaStore.Files.FileColumns.MEDIA_TYPE_VIDEO:
        return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;

      default:
        return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    }
  }
}
