package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Optional;

/**
 * Created by mika on 2018. 10. 26..
 */

public class Step {

  @Nullable
  private NestedMessage message;

  @Nullable
  public String getPlainText() {
    return Optional.ofNullable(message)
        .map(NestedMessage::getBlocks)
        .map(blocks ->  MessageParserUtils.parseBlocks(blocks, getParseOptions()))
        .map(BlockParseResult::getPlainText)
        .orElse(null);
  }

  @Nullable
  public NestedMessage getMessage() {
    return message;
  }

  private static MessageParseOptions getParseOptions() {
    return MessageParseOptions.MessageParseOptionsBuilder.create()
        .withEnableVariable(true)
        .build();
  }
}
