package com.zoyi.channel.plugin.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;

import java.util.Locale;

public class ChannelPluginSettings {

  @Nullable
  private String pluginKey;
  @Nullable
  private String memberId;
  private boolean debugMode;
  private boolean enabledTrackDefaultEvent;
  private boolean hideDefaultInAppPush;
  @Nullable
  private CHLocale locale;
  @Nullable
  private LauncherConfig launcherConfig;

  public ChannelPluginSettings(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
    this.debugMode = false;
    this.enabledTrackDefaultEvent = Const.DEFAULT_SETTINGS_ENABLED_TRACK_DEFAULT_EVENT;
    this.hideDefaultInAppPush = Const.DEFAULT_SETTINGS_HIDE_DEFAULT_IN_APP_PUSH;
    this.locale = null;
  }

  public static ChannelPluginSettings create(@Nullable String pluginKey) {
    return new ChannelPluginSettings(pluginKey);
  }

  public void setPluginKey(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
  }

  public ChannelPluginSettings setMemberId(@Nullable String memberId) {
    this.memberId = memberId;
    return this;
  }

  public ChannelPluginSettings setDebugMode(@Nullable Boolean debug) {
    if (debug != null) {
      this.debugMode = debug;
    }
    return this;
  }

  public ChannelPluginSettings setEnabledTrackDefaultEvent(@Nullable Boolean enabledTrackDefaultEvent) {
    if (enabledTrackDefaultEvent != null) {
      this.enabledTrackDefaultEvent = enabledTrackDefaultEvent;
    }
    return this;
  }

  public ChannelPluginSettings setHideDefaultInAppPush(@Nullable Boolean hideDefaultInAppPush) {
    if (hideDefaultInAppPush != null) {
      this.hideDefaultInAppPush = hideDefaultInAppPush;
    }
    return this;
  }

  public ChannelPluginSettings setLocale(@Nullable CHLocale locale) {
    this.locale = locale;
    return this;
  }

  public ChannelPluginSettings setLauncherConfig(@Nullable LauncherConfig launcherConfig) {
    this.launcherConfig = launcherConfig;
    return this;
  }

  @Nullable
  public String getPluginKey() {
    return pluginKey;
  }

  @Nullable
  public String getMemberId() {
    return memberId;
  }

  public boolean isDebugMode() {
    return debugMode;
  }

  public boolean isEnabledTrackDefaultEvent() {
    return enabledTrackDefaultEvent;
  }

  public boolean isHideDefaultInAppPush() {
    return hideDefaultInAppPush;
  }

  @NonNull
  public CHLocale getLocale() {
    if (locale != null) {
      return locale;
    }
    return CHLocale.fromString(Locale.getDefault().getLanguage());
  }

  @Nullable
  public LauncherConfig getLauncherConfig() {
    return launcherConfig;
  }
}
