package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.model.etc.LocalImageFile;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.selector2.ImageSelector;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mika on 2017. 1. 11..
 */
public class PhotoAlbumActivity extends BaseActivity2
    implements View.OnClickListener, PhotoViewAttacher.OnPhotoTapListener {

  private static final int ANIMATION_DURATION = 200;

  private View layoutOverlay;
  private ImageButton downloadButton;
  private ImageButton copyLinkButton;
  private ImageButton closeButton;

  private boolean menuVisible = true;

  private PhotoViewPager viewPager;
  private PhotoAlbumPagerAdapter adapter;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_photo_album, Color.BLACK, false);

    boolean localImageMode = getIntent().getBooleanExtra(Const.EXTRA_LOCAL_IMAGE_MODE, false);
    String localImageUrl = getIntent().getStringExtra(Const.EXTRA_LOCAL_IMAGE_URL);
    String fileId = getIntent().getStringExtra(Const.EXTRA_FILE_ID);

    layoutOverlay = findViewById(R.id.layout_image);
    viewPager = findViewById(R.id.photo_view_pager);
    copyLinkButton = findViewById(R.id.button_link);
    downloadButton = findViewById(R.id.button_download);
    closeButton = findViewById(R.id.button_close_image);

    downloadButton.setOnClickListener(this);
    copyLinkButton.setOnClickListener(this);
    closeButton.setOnClickListener(this);

    Views.setVisibility(downloadButton, !localImageMode);
    Views.setVisibility(copyLinkButton, !localImageMode);

    List<FileMeta> imageFiles = new ArrayList<>();
    int selectedImageIndex = -1;

    if (localImageMode && localImageUrl != null) {
      imageFiles.add(LocalImageFile.create(localImageUrl));
      selectedImageIndex = 0;
    } else {
      List<File> files = ImageSelector.getImageFiles();

      imageFiles.addAll(files);

      for (int i = 0; i < files.size(); i++) {
        File file = files.get(i);

        if (file != null && file.getId() != null && file.getId().equals(fileId)) {
          selectedImageIndex = i;
          break;
        }
      }
    }

    adapter = new PhotoAlbumPagerAdapter(this, imageFiles, this);
    viewPager.setAdapter(adapter);

    if (!ListUtils.hasItems(imageFiles) || selectedImageIndex < 0) {
      finish();
      return false;
    }

    viewPager.setCurrentItem(selectedImageIndex);

    return true;
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.button_close_image) {
      finish();
    }
    if (id == R.id.button_link) {
      copyLink();
    }
    if (id == R.id.button_download) {
      download();
    }
  }

  private void copyLink() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      try {
        ClipboardManager clipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
        ClipData clip = ClipData.newPlainText("text", fileMeta.getUrl());
        clipboard.setPrimaryClip(clip);

        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.url_copied_to_clipboard"));
      } catch (Exception ex) {
        UIUtils.showToast(this, ResUtils.getString(this, "ch.photo.read_file_info_failed"));
      }
    }
  }

  private void download() {
    FileMeta fileMeta = adapter.getItem(viewPager.getCurrentItem());
    if (fileMeta != null) {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, fileMeta.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, fileMeta.getName())
          .putExtra(Const.EXTRA_IMAGE, true)
          .setTransition(Transition.NONE)
          .startActivity();
    }
  }

  @Override
  public void onPhotoTap(View view, float x, float y) {
    animateOverlay();
  }

  @Override
  public void onOutsidePhotoTap() {
    animateOverlay();
  }

  private void animateOverlay() {
    layoutOverlay.animate()
        .alpha(menuVisible ? 0f : 1f)
        .setDuration(ANIMATION_DURATION)
        .setListener(animatorListener).start();
  }

  private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener() {
    @Override
    public void onAnimationStart(Animator animator) {
      menuVisible = !menuVisible;

      if (menuVisible) {
        layoutOverlay.setVisibility(View.VISIBLE);
      }
    }

    @Override
    public void onAnimationEnd(Animator animator) {
      layoutOverlay.setVisibility(menuVisible ? View.VISIBLE : View.GONE);
    }

    @Override
    public void onAnimationCancel(Animator animator) {
    }

    @Override
    public void onAnimationRepeat(Animator animator) {
    }
  };
}
