package com.zoyi.channel.plugin.android.activity.lounge;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.PushBotAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat3.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.settings2.SettingsActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.scrollview.NestedScrollViewBottomPlaceholderLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;

public class LoungeActivity extends BaseActivity2 implements LoungeContract.View, OnChatClickListener, LoungeHeaderInteractionListener {

  private LoungeCoordinatorLayout layoutCoordinator;
  private LoungeHeaderView headerLounge;

  private View buttonCloseLounge;

  private View layoutPreviewHeader;

  // chat
  private View layoutPreviewChat;
  private RecyclerView recyclerViewChat;
  private View buttonChatStartChats;
  private ChatStartButton buttonChatStartWelcome;
  private CHTextView textLoungeSeeMoreChats;

  // welcome message
  private View layoutPreviewWelcome;
  private AvatarLayout avatarWelcomeMessageProfile;
  private TextView textWelcomeMessageProfile;
  private EllipsizeTextView textWelcomeMessage;

  // bottom layout
  private PaddingNestedScrollView scrollViewLounge;
  private NestedScrollViewBottomPlaceholderLayout bottomLayout;
  private ChannelWatermarkView watermark;

  private View layoutPreviewLoading;
  private ErrorRefreshView layoutPreviewError;

  private LoungeAdapter adapter;
  private LoungeContract.Presenter presenter;

  private LinearLayoutManager layoutManager;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_lounge);

    setOutTransition(Transition.SLIDE_FROM_BOTTOM);

    layoutCoordinator = findViewById(R.id.layoutLoungeCoordinator);

    headerLounge = findViewById(R.id.viewLoungeHeader);
    headerLounge.setLoungeHeaderInteractionListener(this);

    buttonCloseLounge = findViewById(R.id.buttonCloseLounge);
    buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));

    layoutPreviewHeader = findViewById(R.id.viewLoungePreviewHeader);

    layoutPreviewChat = findViewById(R.id.layoutLoungePreviewChat);

    layoutPreviewWelcome = findViewById(R.id.layoutLoungePreviewWelcomeMessage);
    layoutPreviewWelcome.setOnClickListener(v -> startEmptyChat());

    layoutPreviewLoading = findViewById(R.id.layoutLoungePreviewLoader);

    layoutPreviewError = findViewById(R.id.layoutLoungePreviewError);
    layoutPreviewError.setListener(v -> presenter.fetchPreviewData());

    avatarWelcomeMessageProfile = findViewById(R.id.avatarLoungePreviewWelcomeMessage);
    textWelcomeMessageProfile = findViewById(R.id.textLoungePreviewWelcomeMessageName);
    textWelcomeMessage = findViewById(R.id.textLoungePreviewWelcomeMessageMessage);

    layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
      float maxScrollPosition = Math.min(scrollPosition, headerHeight);
      float closeButtonAlpha = maxScrollPosition / headerHeight;

      headerLounge.setAlpha(1 - closeButtonAlpha);
      buttonCloseLounge.setAlpha(closeButtonAlpha);
      buttonCloseLounge.setVisibility(scrollPosition == 0 ? View.GONE : View.VISIBLE);
    });

    adapter = new LoungeAdapter();
    adapter.setListener(this);

    buttonChatStartChats = findViewById(R.id.buttonLoungePreviewChatStartChats);
    buttonChatStartChats.setOnClickListener(v -> startEmptyChat());

    layoutManager = new LinearLayoutManager(this);

    recyclerViewChat = findViewById(R.id.recyclerLoungePreviewChat);
    recyclerViewChat.setLayoutManager(layoutManager);
    recyclerViewChat.setAdapter(adapter);
    recyclerViewChat.setItemAnimator(null);
    recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);

    // bottom layout

    scrollViewLounge = findViewById(R.id.scrollViewLounge);
    watermark = findViewById(R.id.watermarkLounge);
    bottomLayout = findViewById(R.id.bottomLayoutLounge);
    bottomLayout.setNestedScrollView(scrollViewLounge, scrollable -> watermark.setBackgroundVisibility(scrollable));

    buttonChatStartWelcome = findViewById(R.id.buttonLoungePreviewChatStartWelcome);
    buttonChatStartWelcome.setOnClickListener(v -> startEmptyChat());

    textLoungeSeeMoreChats = findViewById(R.id.textLoungeSeeMoreChats);
    textLoungeSeeMoreChats.setOnClickListener(v -> showChats());
    textLoungeSeeMoreChats.setOnTextContentChangeListener((localizeString, data) -> {
      if (data instanceof Integer && (Integer) data > 0) {
        return String.format(localizeString, Utils.getCount((Integer) data, false));
      }
      return null;
    });

    presenter = new LoungePresenter(this, adapter, adapter);
    bindPresenter(presenter);

    // Set states

    GlobalStore.get().messengerState.set(true);

    InAppPushStore.get().inAppPushItem.set(null);

    PushBotAction.hideAllPushBots();

    // handle intent

    Intent intent = getIntent();

    if (intent != null) {
      startChat(
          ChatContentType.fromString(intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_TYPE)),
          intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID),
          Transition.SLIDE_FROM_BOTTOM
      );
    }

    return true;
  }

  @Override
  protected void onNewIntent(Intent intent) {
    super.onNewIntent(intent);

    if (intent != null) {
      startChat(
          ChatContentType.fromString(intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_TYPE)),
          intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID),
          Transition.SLIDE_FROM_RIGHT
      );
    }
  }

  @Override
  protected void onPause() {
    super.onPause();

    if (isFinishing()) {
      GlobalStore.get().messengerState.set(false);

      Action.invoke(ActionType.MESSENGER_CLOSED);
    }
  }

  // handle change

  @Override
  public void onPreviewStateChange(PreviewState previewState, int invisibleChatsCount) {
    layoutPreviewChat.setVisibility(View.GONE);
    layoutPreviewHeader.setVisibility(View.GONE);
    layoutPreviewWelcome.setVisibility(View.GONE);
    layoutPreviewLoading.setVisibility(View.GONE);
    layoutPreviewError.setVisibility(View.GONE);
    buttonChatStartWelcome.setVisibility(View.GONE);
    textLoungeSeeMoreChats.setVisibility(View.GONE);

    switch (previewState) {
      case CHATS:
        layoutPreviewHeader.setVisibility(View.VISIBLE);
        layoutPreviewChat.setVisibility(View.VISIBLE);

        Views.setVisibility(textLoungeSeeMoreChats, invisibleChatsCount > 0);
        textLoungeSeeMoreChats.setData(invisibleChatsCount);
        break;

      case WELCOME:
        layoutPreviewWelcome.setVisibility(View.VISIBLE);
        buttonChatStartWelcome.setVisibility(View.VISIBLE);

        Views.setVisibility(textLoungeSeeMoreChats, invisibleChatsCount > 0);
        textLoungeSeeMoreChats.setData(invisibleChatsCount);
        break;

      case LOADING:
        layoutPreviewLoading.setVisibility(View.VISIBLE);
        break;

      case FAILED:
        layoutPreviewError.setVisibility(View.VISIBLE);
        break;
    }
  }

  @Override
  public void onDefaultProfileChange(ProfileEntity profileEntity) {
    if (profileEntity != null) {
      avatarWelcomeMessageProfile.set(profileEntity);
      textWelcomeMessageProfile.setText(profileEntity.getName());
    }
  }

  @Override
  public void onWelcomeMessageChange(String message) {
    if (message != null) {
      textWelcomeMessage.setText(ParseUtils.parseMessage(message));
    }
  }

  @Override
  public void onChatItemClick(@NonNull ChatItem chatItem) {
    startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
  }

  @Override
  public void onChatItemLongClick(@NonNull ChatItem chatItem) {
    new ChannelDialog(this)
        .setDescription(ResUtils.getString("ch.chat.delete_description"))
        .addButton(ButtonType.CANCEL)
        .addButton(ButtonType.OK, (v) -> presenter.removeChat(chatItem))
        .allowBackpress(true)
        .show();
  }

  // private methods

  private void showChats() {
    IntentUtils.setNextActivity(this, ChatsActivity.class).startActivity();
  }

  @Override
  public void onSettingsClick() {
    IntentUtils.setNextActivity(this, SettingsActivity.class).startActivity();
  }

  @Override
  public void onExitClick() {
    Action.invoke(ActionType.EXIT);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    if (requestCode == Const.REQUEST_CHAT && resultCode == Const.RESULT_CHAT_OPEN_NEW_CHAT) {
      startEmptyChat(Transition.NONE);
    }
  }

  private void startEmptyChat() {
    ChatUtils.createChatActivityIntent(this).startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startEmptyChat(Transition transition) {
    ChatUtils.createChatActivityIntent(this)
        .setTransition(transition)
        .startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
    if ((contentType == ChatContentType.USER_CHAT || contentType == ChatContentType.PUSH_BOT_CHAT) && contentId != null) {
      ChatUtils.createChatActivityIntent(this)
          .putExtra(Const.EXTRA_CHAT_CONTENT_TYPE, contentType.toString())
          .putExtra(Const.EXTRA_CHAT_CONTENT_ID, contentId)
          .setTransition(transition)
          .startActivityForResult(Const.REQUEST_CHAT);
    }
  }
}
