/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.video;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.Player;
import com.zoyi.com.google.android.exoplayer2.RenderersFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;

public class VideoViewerActivity
extends BaseActivity2 {
    private PlayerView videoPlayerView;
    private ImageButton downloadButton;
    @Nullable
    private SimpleExoPlayer exoPlayer;
    private String url;
    private String fileName;
    private long lastPosition;
    private boolean playWhenReady;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_video_viewer, -16777216, false);
        this.url = this.getIntent().getStringExtra("url");
        this.fileName = this.getIntent().getStringExtra("filename");
        this.videoPlayerView = (PlayerView)this.findViewById(R.id.view_video_player);
        this.downloadButton = (ImageButton)this.findViewById(R.id.exo_download);
        if (this.url == null || this.fileName == null) {
            return false;
        }
        this.downloadButton.setOnClickListener(v -> IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", this.url).putExtra("filename", this.fileName).putExtra("image", false).setTransition(Transition.NONE).startActivity());
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this, (RenderersFactory)new DefaultRenderersFactory((Context)this), (TrackSelector)trackSelector);
        this.videoPlayerView.setPlayer((Player)this.exoPlayer);
        DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory((Context)this, Util.getUserAgent((Context)this, (String)"ChannelTalkSDK"));
        ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)this.url));
        this.exoPlayer.prepare((MediaSource)videoSource);
        return true;
    }

    protected void onStart() {
        super.onStart();
        if (this.exoPlayer != null) {
            this.exoPlayer.seekTo(this.lastPosition);
            this.exoPlayer.setPlayWhenReady(this.playWhenReady);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.exoPlayer != null) {
            this.lastPosition = this.exoPlayer.getCurrentPosition();
            this.playWhenReady = this.exoPlayer.getPlayWhenReady();
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.exoPlayer != null) {
            this.exoPlayer.release();
            this.exoPlayer = null;
        }
    }
}

