/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.functions.Action0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleObserveOn<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Scheduler scheduler;

    public SingleObserveOn(Single.OnSubscribe<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        Scheduler.Worker w = this.scheduler.createWorker();
        ObserveOnSingleSubscriber<? super T> parent = new ObserveOnSingleSubscriber<T>(t, w);
        t.add(w);
        t.add(parent);
        this.source.call(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObserveOnSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final Scheduler.Worker w;
        T value;
        Throwable error;

        public ObserveOnSingleSubscriber(SingleSubscriber<? super T> actual, Scheduler.Worker w) {
            this.actual = actual;
            this.w = w;
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.w.schedule(this);
        }

        @Override
        public void onError(Throwable error) {
            this.error = error;
            this.w.schedule(this);
        }

        @Override
        public void call() {
            try {
                Throwable ex = this.error;
                if (ex != null) {
                    this.error = null;
                    this.actual.onError(ex);
                } else {
                    T v = this.value;
                    this.value = null;
                    this.actual.onSuccess(v);
                }
            }
            finally {
                this.w.unsubscribe();
            }
        }
    }
}

