/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ActionView
extends BaseDTO
implements InterfaceDataType {
    private String viewName = "NA";
    private String lastName = "NA";
    private String host = "NA";
    private String domainLookupTime = "NA";
    private String domProcessingTime = "NA";
    private String serverTime = "NA";
    private String loadTime = "NA";
    private String elapsedTime = "NA";

    public ActionView(byte type, String viewName, Integer domainLookupTime, Integer domProcessingTime, Integer serverTime, String host, Integer loadTime, HashMap<String, Object> extraData) {
        super(type, extraData);
        this.viewName = viewName;
        this.lastName = Properties.lastView;
        Properties.lastView = viewName;
        this.domainLookupTime = domainLookupTime == null ? "NA" : String.valueOf(domainLookupTime);
        this.domProcessingTime = domProcessingTime == null ? "NA" : String.valueOf(domProcessingTime);
        this.serverTime = serverTime == null ? "NA" : String.valueOf(serverTime);
        this.host = host == null || host.length() == 0 ? "NA" : String.valueOf(host);
        this.loadTime = loadTime == null ? "NA" : String.valueOf(loadTime);
        long currentTimestamp = System.currentTimeMillis();
        this.elapsedTime = Properties.lastViewTime == 0L ? "NA" : String.valueOf(currentTimestamp - Properties.lastViewTime);
        Properties.lastViewTime = currentTimestamp;
    }

    public static final synchronized void logView(String viewName, HashMap<String, Object> extraData) {
        new ActionView(8, viewName, null, null, null, null, null, extraData).save();
    }

    public static final synchronized void logView(String viewName, Integer domainLookupTime, Integer domProcessingTime, Integer serverTime, String host, Integer loadTime, HashMap<String, Object> extraData) {
        new ActionView(8, viewName, domainLookupTime, domProcessingTime, domProcessingTime, host, loadTime, extraData).save();
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            if (this.viewName != null) {
                json.put("current", (Object)this.viewName);
                json.put("previous", (Object)this.lastName);
                json.put("domainLookupTime", (Object)this.domainLookupTime);
                json.put("domProcessingTime", (Object)this.domProcessingTime);
                json.put("serverTime", (Object)this.serverTime);
                json.put("host", (Object)this.host);
                json.put("loadTime", (Object)this.loadTime);
                json.put("elapsedTime", (Object)this.elapsedTime);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator((byte)8);
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save() {
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }
}

