package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.ManagerStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;

import java.util.List;

/**
 * Created by mika on 2016. 12. 8..
 */
public class UserChatWrapper extends BaseRepo {

  private UserChat userChat;
  private Session session;
  private List<Manager> managers;
  private Message message;

  public UserChat getUserChat() {
    return userChat;
  }

  public Session getSession() {
    return session;
  }

  public List<Manager> getManagers() {
    return managers;
  }

  public Message getMessage() {
    return message;
  }

  @Override
  public void update() {
    ManagerStore.get().managers.add(managers);
    UserChatStore.get().userChats.upsert(userChat);
    UserChatStore.get().sessions.upsert(session);
    UserChatStore.get().messages.upsert(message);
  }
}
