package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by mika on 2016. 12. 22..
 */
public class SendingMessageItem extends ConnectableMessageItem implements MessageItem {

  @Nullable
  private String chatId;
  @NonNull
  private String requestId;
  @Nullable
  private String text;
  @Nullable
  private String filePath;
  @Nullable
  private String actionType;
  @Nullable
  private ActionButton actionButton;
  @NonNull
  private ContentType contentType;
  @NonNull
  private SendingState sendingState;
  private boolean isFailToSend;

  private Long createdAt;

  @Nullable
  public static SendingMessageItem createDummy(@Nullable String requestId) {
    if (requestId == null) {
      return null;
    }
    SendingMessageItem item = new SendingMessageItem();
    item.requestId = requestId;
    try {
      item.createdAt = Long.parseLong(requestId.substring(0, 13));
    } catch (Exception ex) {
    }
    return item;
  }

  @NonNull
  public static SendingMessageItem copyContentFrom(@Nullable SendingMessageItem item) {
    if (item != null) {
      return new SendingMessageItem(item);
    }
    return new SendingMessageItem();
  }

  private SendingMessageItem() {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = "";
    this.contentType = ContentType.NONE;
    this.sendingState = SendingState.WAITING;
  }

  public SendingMessageItem(@Nullable String chatId) {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = createdAt + Utils.getRandomString(4);
    this.chatId = chatId;
    this.isFailToSend = false;
    this.contentType = ContentType.NONE;
    this.sendingState = SendingState.WAITING;
  }

  // For copying object
  private SendingMessageItem(@NonNull SendingMessageItem item) {
    this.createdAt = TimeUtils.getCurrentTime();
    this.requestId = createdAt + Utils.getRandomString(4);
    this.chatId = item.getChatId();
    this.text = item.getText();
    this.filePath = item.getFilePath();
    this.actionType = item.getActionType();
    this.actionButton = item.getActionButton();
    this.contentType = item.getContentType();
    this.isFailToSend = false;
    this.sendingState = SendingState.WAITING;
  }

  @Override
  public Long getPrimaryKey() {
    return createdAt * 10;
  }

  @Override
  public String getSecondaryKey() {
    return requestId;
  }

  @NonNull
  public String getRequestId() {
    return requestId;
  }

  @Override
  public MessageType getType() {
    return MessageType.SENDING;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  public void setChatId(String chatId) {
    this.chatId = chatId;
  }

  public Long getCreatedAt() {
    return createdAt;
  }

  public ContentType getContentType() {
    return contentType;
  }

  @NonNull
  public SendingState getSendingState() {
    return sendingState;
  }

  public void setSendingState(@NonNull SendingState sendingState) {
    this.sendingState = sendingState;
  }

  // Content getter/setter

  @Nullable
  public String getText() {
    return text;
  }

  public SendingMessageItem setText(@Nullable String text) {
    if (text != null) {
      this.text = text;
      this.contentType = ContentType.TEXT;
    }
    return this;
  }

  @Nullable
  public String getFilePath() {
    return filePath;
  }

  public SendingMessageItem setFilePath(@Nullable String filePath) {
    if (filePath != null) {
      this.filePath = filePath;
      this.contentType = ContentType.FILE;
    }
    return this;
  }

  @Nullable
  public String getActionType() {
    return actionType;
  }

  @Nullable
  public ActionButton getActionButton() {
    return actionButton;
  }

  public SendingMessageItem setActionBundle(@NonNull String actionType, @Nullable ActionButton actionButton) {
    this.actionType = actionType;
    this.actionButton = actionButton;
    this.contentType = ContentType.ACTION;
    return this;
  }

  // 서포트 봇으로 유저챗 생성 시에 실제 메시지를 설정해주는 함수
  public void updateMessageOnActionInput(@NonNull Message message) {
    if (contentType == ContentType.ACTION && actionButton != null) {
      actionButton.setMessage(message);
    }
  }

  // etc getters

  @Override
  public boolean isSamePerson(@NonNull ConnectableMessageItem item) {
    if (item instanceof SendingMessageItem) {
      return true;
    } else if (item instanceof ChatMessageItem) {
      return ((ChatMessageItem) item).getType() == MessageType.GUEST;
    }
    return false;
  }
}
