/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.selector2.ProfileSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class Typing
implements Entity {
    public static final long TTL = 30L;
    private String action;
    private String chatId;
    private String chatType;
    private String personId;
    private String personType;
    private Long createdAt;

    public Typing() {
    }

    public Typing(String action, String chatId, String chatType) {
        this.action = action;
        this.chatId = chatId;
        this.chatType = chatType;
    }

    public String getAction() {
        return this.action;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean isOther() {
        return "Manager".equals(this.personType) || "Bot".equals(this.personType);
    }

    public boolean isExpired() {
        return this.createdAt != null && TimeUtils.getCurrentTime() - this.createdAt >= 30L;
    }

    public String getKey() {
        return String.format("%s:%s:%s:%s", this.chatId, this.chatType, this.personId, this.personType);
    }

    public ProfileEntity getProfileEntity() {
        return ProfileSelector.getProfile(this.personType, this.personId);
    }

    public boolean isSameChat(String chatId, String chatType) {
        return this.chatId.equals(chatId) && this.chatType.equals(chatType);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof Typing) {
            Typing next = (Typing)o;
            ret = this.chatId.equals(next.chatId) && this.chatType.equals(next.chatType) && this.personId.equals(next.personId) && this.personType.equals(next.personType);
        }
        return ret;
    }

    @Override
    public String getId() {
        return String.format("%s:%s:%s:%s", this.chatType, this.chatId, this.personType, this.personId);
    }

    public static Typing dummy() {
        return new Typing();
    }

    public static Typing create(String action, String chatId) {
        return new Typing(action, chatId, "UserChat");
    }
}

