package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;

public class PushBotChatItem implements ChatItem {

  private PushBotItem pushBotItem;

  public PushBotChatItem(PushBotItem pushBotItem) {
    this.pushBotItem = pushBotItem;
  }

  @Nullable
  @Override
  public String getId() {
    if (pushBotItem != null) {
      return pushBotItem.getId();
    }
    return null;
  }

  @Nullable
  @Override
  public ProfileEntity getProfile() {
    return pushBotItem.getProfile();
  }

  @Nullable
  @Override
  public Long getUpdatedAt() {
    return pushBotItem.getCreatedAt();
  }

  @Override
  public String getMessage() {
    return pushBotItem.getFormattedSpanMessage().toString();
  }

  @Override
  public boolean isActive() {
    return true;
  }

  @Override
  public int getCount() {
    return pushBotItem.getAlertCount();
  }

  @Nullable
  @Override
  public String getSubKey() {
    return pushBotItem.getId();
  }

  @Override
  public ChatContentType getType() {
    return ChatContentType.PUSH_BOT_CHAT;
  }

  public PushBotItem getPushBotItem() {
    return pushBotItem;
  }
}
