package com.zoyi.channel.plugin.android.store2.base;

import android.support.annotation.NonNull;

import java.util.HashMap;
import java.util.Map;

public abstract class Store2 {

  private static final Map<Class<? extends Store2>, Store2> instances = new HashMap<>();

  @NonNull
  public static <T extends Store2> T getInstance(Class<T> clazz) {
    if (instances.get(clazz) == null) {
      synchronized (instances) {
        if (instances.get(clazz) == null) {
          try {
            instances.put(clazz, clazz.newInstance());
          } catch (InstantiationException e) {
            e.printStackTrace();
          } catch (IllegalAccessException e) {
            e.printStackTrace();
          }
        }
      }
    }
    return (T) instances.get(clazz);
  }

  public static void destroy() {
    synchronized (instances) {
      for (Store2 store2 : instances.values()) {
        store2.reset();
      }
    }
  }

  protected abstract void reset();
}
