package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class MaxSizeLinearLayout extends LinearLayout {

  private int maxWidthSize;

  public MaxSizeLinearLayout(Context context) {
    super(context);
  }

  public MaxSizeLinearLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public MaxSizeLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  protected void init(Context context, @Nullable AttributeSet attrs) {
    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.MaxSizeLinearLayout,
          0,
          0);

      try {
        maxWidthSize = typedArray.getDimensionPixelSize(R.styleable.MaxSizeLinearLayout_ch_max_width, maxWidthSize);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int popupWidth = View.MeasureSpec.getSize(widthMeasureSpec);

    if (maxWidthSize < popupWidth) {
      popupWidth = maxWidthSize;
    }

    widthMeasureSpec = MeasureSpec.makeMeasureSpec(popupWidth, MeasureSpec.getMode(widthMeasureSpec));

    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
  }
}
