package com.zoyi.channel.plugin.android.global;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.subjects.PublishSubject;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Action {

  /* static fields */

  private static PublishSubject<ActionType> publishSubject = PublishSubject.create();

  private static Map<ActionType, RestSubscriber<?>> apiSubscribers = new ConcurrentHashMap<>();

  private static Map<ActionType, Set<RestSubscriber>> canceller = new ConcurrentHashMap<>();

  static <E> void apiSubscribe(
      Observable<E> observable,
      RestSubscriber<E> subscriber,
      @Nullable ActionType targetActionType,
      @Nullable ActionType[] cancelActionTypes
  ) {
    observable.subscribe(subscriber);

    subscriber.setActionSubscription(targetActionType, cancelActionTypes);

    if (targetActionType != null) {
      cancel(targetActionType);

      apiSubscribers.put(targetActionType, subscriber);
    }

    if (cancelActionTypes != null) {
      for (ActionType cancelType : cancelActionTypes) {
        if (canceller.get(cancelType) == null) {
          canceller.put(cancelType, new HashSet<>());
        }

        Set<RestSubscriber> cancelSet = canceller.containsKey(cancelType) ? canceller.get(cancelType) : null;

        if (cancelSet != null) {
          cancelSet.add(subscriber);
        }
      }
    }
  }

  private static void cancel(ActionType actionType) {
    // cancel target action

    if (apiSubscribers != null) {
      RestSubscriber subscriber = apiSubscribers.get(actionType);

      if (subscriber != null) {
        if (!subscriber.isUnsubscribed()) {
          subscriber.unsubscribe();
        }

        if (canceller != null && subscriber.getCancelTypes().length > 0) {
          for (ActionType cancelType : subscriber.getCancelTypes()) {
            Set<RestSubscriber> cancelSet = canceller.get(cancelType);

            if (cancelSet != null) {
              cancelSet.remove(subscriber);
            }
          }
        }

        apiSubscribers.remove(actionType);
      }
    }

    // cancel by cancel action types

    if (canceller != null) {
      Set<RestSubscriber> cancelSet = canceller.get(actionType);

      if (cancelSet != null) {
        for (RestSubscriber subscriber : cancelSet) {
          if (subscriber != null) {
            if (!subscriber.isUnsubscribed()) {
              subscriber.unsubscribe();
            }
            if (subscriber.getActionType() != null) {
              apiSubscribers.remove(subscriber.getActionType());
            }
          }
        }
        cancelSet.clear();
      }
    }
  }

  public static void invoke(ActionType actionType) {
    cancel(actionType);

    if (publishSubject != null) {
      publishSubject.onNext(actionType);
    }
  }

  public static boolean isRunning(ActionType actionType) {
    if (apiSubscribers.containsKey(actionType)) {
      Subscription subscription = apiSubscribers.get(actionType);

      return subscription != null && !subscription.isUnsubscribed();
    }
    return false;
  }

  public static Observable<ActionType> observable() {
    return publishSubject
        .onBackpressureBuffer()
        .observeOn(AndroidSchedulers.mainThread());
  }

  public static void release() {
    for (Subscription subscription : apiSubscribers.values()) {
      if (subscription != null && !subscription.isUnsubscribed()) {
        subscription.unsubscribe();
      }
    }
    apiSubscribers.clear();
    canceller.clear();
  }
}
