/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.io;

import com.splunk.mint.network.Counter;
import com.splunk.mint.network.MonitorRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class OutputStreamMonitor
extends OutputStream {
    public static final String OUT_POSTFIX = "-bytes-out";
    private final OutputStream original;
    private final Counter counter;
    private List<Byte> chars;
    private StringBuffer body;
    private static final int MAX_POSSIBLE_HEADER_LENGTH = 50;

    public OutputStreamMonitor(String name, MonitorRegistry registry, OutputStream original) {
        this.original = original;
        this.counter = new Counter(name + OUT_POSTFIX);
        registry.add(this.counter);
        this.chars = new ArrayList<Byte>();
        this.body = new StringBuffer();
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.counter.inc();
        this.original.write(oneByte);
        this.chars.add((byte)oneByte);
        this.updateBody();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.counter.inc(buffer.length);
        this.original.write(buffer);
        for (int i = 0; i < buffer.length; ++i) {
            this.chars.add(buffer[i]);
        }
        this.updateBody();
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.counter.inc(count);
        this.original.write(buffer, offset, count);
        for (int i = offset; i < count; ++i) {
            this.chars.add(buffer[i]);
        }
        this.updateBody();
    }

    private void updateBody() {
        byte[] data = new byte[this.chars.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.chars.get(i);
        }
        this.chars.clear();
        this.body.append(new String(data));
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    public HashMap<String, List<String>> getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(1);
        if (this.body != null && this.body.toString() != null && this.body.toString().length() > 50) {
            try {
                BufferedReader in = new BufferedReader(new StringReader(this.body.toString()));
                String line = null;
                boolean host1Found = false;
                boolean host2Found = false;
                while ((line = in.readLine()) != null) {
                    String name;
                    int start;
                    if (!host1Found && line.contains(":") && line.length() < 50 && (start = line.indexOf(":")) > -1 && (name = line.substring(0, start).trim()).equals("Host")) {
                        String[] array = new String[]{line.substring(start + 1, line.length()).trim()};
                        headers.put(name, Arrays.asList(array));
                        host1Found = true;
                    }
                    if (!host2Found && (line.contains("POST") || line.contains("GET"))) {
                        String[] parts = line.split(" ");
                        String[] array = new String[]{parts[1].trim()};
                        headers.put("splk-host2", Arrays.asList(array));
                        host2Found = true;
                    }
                    if (!host1Found || !host2Found) continue;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return headers;
    }
}

