/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.action;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.util.Utils;

public class ActionButtonLayout
extends LinearLayout {
    private Context context;
    @Nullable
    private LinearLayout lineLayout;
    private int LINE_MARGIN;
    private int availableWidth;
    private int parentWidth;

    public ActionButtonLayout(Context context) {
        super(context);
        this.init(context);
    }

    public ActionButtonLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ActionButtonLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.LINE_MARGIN = (int)Utils.dpToPx(context, 4.0f);
        this.availableWidth = -1;
    }

    public void refresh() {
        this.lineLayout = null;
        this.availableWidth = -1;
    }

    public void add(View actionButtonView) {
        int childWidth = this.getWidth(actionButtonView);
        if (this.availableWidth < childWidth) {
            this.lineLayout = this.getLineLayout(this.context);
            this.addView((View)this.lineLayout);
            this.measure(0, 0);
            this.availableWidth = this.parentWidth;
        }
        if (this.lineLayout != null) {
            this.lineLayout.addView(actionButtonView);
        }
        this.availableWidth = Math.max(-1, this.availableWidth - childWidth);
    }

    public void setWidth(int width) {
        this.parentWidth = width;
    }

    public int getWidth(View view) {
        view.measure(0, 0);
        return view.getMeasuredWidth();
    }

    public LinearLayout getLineLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = this.LINE_MARGIN;
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.setGravity(0x800005);
        return linearLayout;
    }
}

