package com.zoyi.channel.plugin.android.view.handler;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

/**
 * Created by mika on 2016. 1. 22..
 */
public abstract class InfiniteScrollListener extends RecyclerView.OnScrollListener {
  public static final int BOTTOM = -1;
  public static final int TOP = 1;

  private static int THRESHOLD = 3;
  int firstVisibleItem, childCount, totalItemCount, previousTotal = 0;

  private LinearLayoutManager manager;
  private int direction;
  private RecyclerView recyclerView;

  protected InfiniteScrollListener(LinearLayoutManager manager, int direction, RecyclerView recyclerView) {
    this.manager = manager;
    this.direction = direction;
    this.recyclerView = recyclerView;
  }

  @Override
  public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
    super.onScrolled(recyclerView, dx, dy);

    if (firstVisibleItem != manager.findFirstVisibleItemPosition()) {
      firstItem(manager.findFirstVisibleItemPosition());
    }

    childCount = recyclerView.getChildCount();
    totalItemCount = manager.getItemCount();
    firstVisibleItem = manager.findFirstVisibleItemPosition();

    if (!recyclerView.canScrollVertically(1)) {
      scrollAttachedToBottom();
    } else {
      scrolledInList();
    }
    if (dy * this.direction > 0) {
      return;
    }

    if (totalItemCount == 0) {
      return;
    }
    previousTotal = totalItemCount;

    if (direction == TOP && firstVisibleItem > THRESHOLD) { return; }
    if (direction == BOTTOM && totalItemCount - this.childCount > firstVisibleItem) { return; }

    refresh();
  }

  public abstract void scrolledInList();

  public abstract void scrollAttachedToBottom();

  public abstract void refresh();

  public void firstItem(int index) { }
}