package com.zoyi.channel.plugin.android.activity.common.chat;

import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by jerry on 2018. 11. 27..
 */

public enum ChatContentType {
  USER_CHAT(Const.CHAT_CONTENT_USER_CHAT),
  PUSH_BOT_CHAT(Const.CHAT_CONTENT_PUSH_BOT),
  SUPPORT_BOT_CHAT(Const.CHAT_CONTENT_SUPPORT_BOT),
  NONE(Const.CHAT_CONTENT_NONE);

  private String value;

  ChatContentType(String value) {
    this.value = value;
  }

  public static ChatContentType fromString(String value) {
    if (value == null) {
      return NONE;
    }

    switch (value) {
      case Const.CHAT_CONTENT_USER_CHAT:
        return USER_CHAT;
      case Const.CHAT_CONTENT_PUSH_BOT:
        return PUSH_BOT_CHAT;
      case Const.CHAT_CONTENT_SUPPORT_BOT:
        return SUPPORT_BOT_CHAT;
      default:
        return NONE;
    }
  }

  @Override
  public String toString() {
    return value;
  }
}
