/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx;

import com.zoyi.rx.exceptions.MissingBackpressureException;

public final class BackpressureOverflow {
    public static final Strategy ON_OVERFLOW_ERROR;
    public static final Strategy ON_OVERFLOW_DEFAULT;
    public static final Strategy ON_OVERFLOW_DROP_OLDEST;
    public static final Strategy ON_OVERFLOW_DROP_LATEST;

    private BackpressureOverflow() {
        throw new IllegalStateException("No instances!");
    }

    static {
        ON_OVERFLOW_DEFAULT = ON_OVERFLOW_ERROR = Error.INSTANCE;
        ON_OVERFLOW_DROP_OLDEST = DropOldest.INSTANCE;
        ON_OVERFLOW_DROP_LATEST = DropLatest.INSTANCE;
    }

    static final class Error
    implements Strategy {
        static final Error INSTANCE = new Error();

        private Error() {
        }

        public boolean mayAttemptDrop() throws MissingBackpressureException {
            throw new MissingBackpressureException("Overflowed buffer");
        }
    }

    static final class DropLatest
    implements Strategy {
        static final DropLatest INSTANCE = new DropLatest();

        private DropLatest() {
        }

        public boolean mayAttemptDrop() {
            return false;
        }
    }

    static final class DropOldest
    implements Strategy {
        static final DropOldest INSTANCE = new DropOldest();

        private DropOldest() {
        }

        public boolean mayAttemptDrop() {
            return true;
        }
    }

    public static interface Strategy {
        public boolean mayAttemptDrop() throws MissingBackpressureException;
    }
}

