package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class InAppPushView extends BasePopupView {

  @Nullable
  private InAppPushItem inAppPushItem;

  public InAppPushView(@NonNull Context context) {
    super(context);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public InAppPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void init(final Context context) {
    super.init(context);

    root.setOnClickListener(v -> {
      if (inAppPushItem != null) {
        ChannelIO.openChat(context, inAppPushItem.getChatId());
      }
      requestHide();
    });

    buttonPopupClose.setOnClickListener(v -> requestHide());
  }

  @Override
  protected void requestHide() {
    InAppPushStore.get().inAppPushItem.set(null);
  }

  @Override
  protected void resetPopupContent() { }

  public void show(@Nullable InAppPushItem inAppPushItem) {
    this.inAppPushItem = inAppPushItem;

    if (inAppPushItem != null) {
      super.bindPopupData(inAppPushItem);

      root.setVisibility(VISIBLE);
    }
  }
}
