package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector2.PluginSelector;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

/**
 * Created by jerry on 2018. 11. 20..
 */

public class PushBotPopupView extends BasePopupView {

  private ViewGroup layoutPushBotPopupImage;
  private ImageView imagePushBotPopupImage;
  private FrameLayout buttonPushBotPopupButton;
  private View viewPushBotPopupButtonContent;
  private ImageView imagePushBotPopupButtonContent;

  @Nullable
  private OnPushBotClickListener onPushBotClickListener;

  @Nullable
  private PushBotItem pushBotItem;

  @Nullable
  private Binder binder;

  public PushBotPopupView(@NonNull Context context) {
    super(context);
  }

  public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public PushBotPopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void init(final Context context) {
    super.init(context);

    layoutPushBotPopupImage = root.findViewById(R.id.ch_layout_popup_image);
    imagePushBotPopupImage = root.findViewById(R.id.ch_image_popup_image);
    viewPushBotPopupButtonContent = root.findViewById(R.id.ch_view_popup_button_content);
    imagePushBotPopupButtonContent = root.findViewById(R.id.ch_image_popup_button_content);
    buttonPushBotPopupButton = root.findViewById(R.id.ch_layout_popup_button);

    root.setOnClickListener(v -> {
      if (pushBotItem != null && onPushBotClickListener != null) {
        onPushBotClickListener.onPushBotClick(pushBotItem.getId());
      }
      requestHide();
    });

    layoutPushBotPopupImage.setOnClickListener(v -> {
      if (pushBotItem != null && onPushBotClickListener != null) {
        onPushBotClickListener.onPushBotContentsClick(pushBotItem.getId(), pushBotItem.getImageRedirectUrl());
      }
      requestHide();
    });

    buttonPushBotPopupButton.setOnClickListener(v -> {
      if (pushBotItem != null && onPushBotClickListener != null) {
        onPushBotClickListener.onPushBotContentsClick(pushBotItem.getId(), pushBotItem.getButtonRedirectUrl());
      }
      requestHide();
    });
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = PluginSelector.bindPlugin(plugin -> {
      viewPushBotPopupButtonContent.setBackgroundColor(plugin.getBackgroundColor());
      imagePushBotPopupButtonContent
          .setImageResource(plugin.getTextColor() == Color.BLACK ? R.drawable.arrow_right_bk : R.drawable.arrow_right_wh);
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
    }
  }

  public void setPushBotClickListener(OnPushBotClickListener onPushBotClickListener) {
    this.onPushBotClickListener = onPushBotClickListener;
  }

  public void show(@NonNull PushBotItem pushBotItem) {
    this.pushBotItem = pushBotItem;

    super.bindPopupData(pushBotItem);
    bindPushBotItem(pushBotItem);

    root.setVisibility(VISIBLE);
  }

  private void bindPushBotItem(@NonNull PushBotItem pushBotItem) {
    // Set button or image

    buttonPushBotPopupButton.setVisibility(View.GONE);
    layoutPushBotPopupImage.setVisibility(View.GONE);

    if (pushBotItem.getAttachment() != null) {
      switch (pushBotItem.getAttachment()) {
        case Const.PUSH_BOT_ATTACHMENT_BUTTON:
          if (pushBotItem.getButtonTitle() != null) {
            buttonPushBotPopupButton.setVisibility(VISIBLE);
          }
          break;

        case Const.PUSH_BOT_ATTACHMENT_IMAGE:
          PreviewThumb imagePreview = pushBotItem.getImageThumb();
          if (imagePreview != null && imagePreview.getUrl() != null) {
            Glide.with(context)
                .load(imagePreview.getUrl())
                .centerCrop()
                .diskCacheStrategy(DiskCacheStrategy.SOURCE)
                .into(imagePushBotPopupImage);

            layoutPushBotPopupImage.setVisibility(VISIBLE);
          }
          break;
      }
    }
  }

  @Override
  protected void requestHide() {
    if (this.pushBotItem != null) {
      this.pushBotItem.hidePopup();

      PushBotStore.get().pushBots.upsert(this.pushBotItem);

      this.pushBotItem = null;
    }
  }

  @Override
  protected void resetPopupContent() {
    buttonPushBotPopupButton.setVisibility(View.GONE);
    layoutPushBotPopupImage.setVisibility(View.GONE);
  }
}
