/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.SkipAttachChannelView;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;

public class ActivityLifecycleManager
implements Application.ActivityLifecycleCallbacks {
    private int running = 0;

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        L.d("Created: " + activity.getClass().getSimpleName() + " " + this.running);
    }

    public void onActivityStarted(Activity activity) {
        FrameLayout root;
        L.d("Started: " + activity.getClass().getSimpleName() + " " + this.running + " -> " + (this.running + 1));
        if (!ChannelUtils.isChannelPluginActivity((Context)activity) && (root = (FrameLayout)activity.findViewById(R.id.channel_io_view)) == null && !activity.getClass().isAnnotationPresent(SkipAttachChannelView.class)) {
            root = new FrameLayout((Context)activity);
            root.setClipChildren(false);
            root.setClipToPadding(false);
            root.setFitsSystemWindows(true);
            root.setId(R.id.channel_io_view);
            root.addView((View)new ChannelView((Context)activity));
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        GlobalStore.get().topActivity.set(activity);
        if (++this.running == 1 && PluginStore.get().pluginState.get() != null) {
            SocketManager.connect();
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        L.d("Stopped: " + activity.getClass().getSimpleName() + " " + this.running + " -> " + (this.running - 1));
        if (GlobalStore.get().topActivity.get() == activity) {
            GlobalStore.get().topActivity.set(null);
        }
        if (--this.running == 0) {
            SocketManager.disconnect();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        L.d("Destroyed: " + activity.getClass().getSimpleName() + " " + this.running);
    }
}

