package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2018. 8. 24..
 */

public class TokenInterceptor implements Interceptor {

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();
    Response response = chain.proceed(request);

    String jwt = response.header(Const.X_GUEST_JWT);
    if (jwt != null) {
      GlobalStore.get().jwt.set(jwt);
      PrefSupervisor.setJwtToken(ChannelIO.getAppContext(), jwt);
    }

    String veilId = response.header(Const.X_VEIL_ID);
    if (veilId != null) {
      PrefSupervisor.setVeilId(ChannelIO.getAppContext(), veilId);
    }

    return response;
  }
}
