/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream.function;

import com.zoyi.com.annimon.stream.function.ThrowableIntConsumer;

public interface IntConsumer {
    public void accept(int var1);

    public static class Util {
        private Util() {
        }

        public static IntConsumer andThen(final IntConsumer c1, final IntConsumer c2) {
            return new IntConsumer(){

                @Override
                public void accept(int value) {
                    c1.accept(value);
                    c2.accept(value);
                }
            };
        }

        public static IntConsumer safe(ThrowableIntConsumer<Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static IntConsumer safe(final ThrowableIntConsumer<Throwable> throwableConsumer, final IntConsumer onFailedConsumer) {
            return new IntConsumer(){

                @Override
                public void accept(int value) {
                    block2: {
                        try {
                            throwableConsumer.accept(value);
                        }
                        catch (Throwable ex) {
                            if (onFailedConsumer == null) break block2;
                            onFailedConsumer.accept(value);
                        }
                    }
                }
            };
        }
    }
}

