/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelActionHandler;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.action.BootAction;
import com.zoyi.channel.plugin.android.action.EventAction;
import com.zoyi.channel.plugin.android.activity.chat3.manager.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import java.util.concurrent.RejectedExecutionException;

class RealChannelIO {
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ChannelActionHandler handler;

    RealChannelIO(Application application) {
        this.application = application;
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.handler = new ChannelActionHandler();
        ActivityLifecycleManager activityLifecycleManager = new ActivityLifecycleManager();
        SocketManager.create(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifecycleManager);
        Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
            if (Looper.getMainLooper().getThread() == thread) {
                if (this.uncaughtExceptionHandler != null) {
                    this.uncaughtExceptionHandler.uncaughtException(thread, ex);
                }
            } else if (ex instanceof RejectedExecutionException) {
                SocketManager.reconnect();
            }
        });
        new GoogleAdIdTask(application).execute(new Void[0]);
    }

    Application getApplication() {
        return this.application;
    }

    void boot(final @Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, final @Nullable OnBootListener listener) {
        this.shutdown();
        BootAction.boot(pluginSettings, profile, listener, new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(RetrofitException e) {
                BootManager.sendNetworkError(listener, e);
            }

            @Override
            public void onNext(PluginWrapper repo) {
                repo.set();
                RealChannelIO.this.onBoot(pluginSettings, repo.getChannel(), repo.getPlugin(), repo.getGuest(), listener);
            }
        });
    }

    private void onBoot(ChannelPluginSettings pluginSettings, Channel channel, Plugin plugin, Guest guest, @Nullable OnBootListener listener) {
        PrefSupervisor.setPluginSetting((Context)this.application, pluginSettings);
        PrefSupervisor.setBootData((Context)this.application, guest);
        if (pluginSettings != null) {
            PrefSupervisor.setPluginLanguage((Context)this.application, pluginSettings.getLocale());
            SettingsStore.get().launcherConfig.set(pluginSettings.getLauncherConfig());
            SettingsStore.get().hideDefaultInAppPush.set(pluginSettings.isHideDefaultInAppPush());
            SettingsStore.get().enabledTrackDefaultEvent.set(pluginSettings.isEnabledTrackDefaultEvent());
            ChannelIO.setDebugMode(pluginSettings.isDebugMode());
        }
        SettingsStore.get().locale.set(PrefSupervisor.getPluginLocale((Context)this.application));
        SettingsStore.get().showTranslation.set(PrefSupervisor.canTranslateMessage((Context)this.application));
        SettingsStore.get().showClosedChat.set(PrefSupervisor.isShownClosedChat((Context)this.application));
        SettingsStore.get().raiseSoundVibrate.set(PrefSupervisor.isEnabledPushAlarm((Context)this.application));
        ChatManager.initialize();
        if (GlobalStore.get().jwt.get() == null) {
            GlobalStore.get().jwt.set(PrefSupervisor.getJwt((Context)this.application));
        }
        ChannelPushManager.sendTokenToChannelIO((Context)this.application);
        SocketManager.setChannelId(channel.getId());
        if (GlobalStore.get().topActivity.get() != null) {
            SocketManager.connect();
        }
        if (SettingsStore.get().showLauncher.get().booleanValue() && SettingsStore.get().enabledTrackDefaultEvent.get().booleanValue()) {
            EventAction.trackPageView();
        }
        this.handler.handle();
        GlobalStore.get().bootState.set(true);
        if (listener != null) {
            listener.onCompletion(ChannelPluginCompletionStatus.SUCCESS, com.zoyi.channel.plugin.android.Guest.newInstance(guest));
        }
    }

    void shutdown() {
        GlobalStore.get().bootState.set(false);
        this.handler.unHandle();
        Action.release();
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        Action.invoke(ActionType.SHUTDOWN);
        ChatManager.release();
        Store2.destroy();
        PrefSupervisor.clearBootData((Context)this.application);
        String jwt = GlobalStore.get().jwt.get();
        ChannelPushManager.deleteToken((Context)this.application, jwt);
        PrefSupervisor.setJwtToken((Context)this.application, null);
    }

    public boolean startMessenger(@Nullable Context context, @Nullable String chatId, boolean isAnimated) {
        if (!ChannelIO.isInitializedChannelIO()) {
            L.e("Fail to start messenger, please initialize ChannelIO first");
            return false;
        }
        if (!GlobalStore.get().bootState.get().booleanValue()) {
            L.e("Fail to start messenger, please 'Boot' first");
            return false;
        }
        if (context == null) {
            L.e("Fail to start messenger, context can't be NULL");
            return false;
        }
        IntentUtils.setNextActivity(context, LoungeActivity.class).putExtra("chatContentType", ChatContentType.USER_CHAT.toString()).putExtra("chatContentId", chatId).putExtra("animated", isAnimated).setFlag(0x4000000).setTransition(isAnimated ? Transition.SLIDE_FROM_BOTTOM : Transition.NONE).startActivity();
        return true;
    }

    void setListener(@Nullable ChannelPluginListener listener) {
        this.handler.setListener(listener);
    }

    void clearListener() {
        this.handler.clearListener();
    }

    @Nullable
    ChannelPluginListener getListener() {
        return this.handler.getListener();
    }

    private static class GoogleAdIdTask
    extends AsyncTask<Void, Void, String> {
        private Application application;

        GoogleAdIdTask(Application application) {
            this.application = application;
        }

        @Nullable
        protected String doInBackground(Void ... params) {
            try {
                AdvertisingIdClient.Info advertisingIdInfo;
                if (this.application != null && (advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.application)) != null && !advertisingIdInfo.isLimitAdTrackingEnabled()) {
                    return advertisingIdInfo.getId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected void onPostExecute(String adId) {
            GlobalStore.get().adId.set(adId);
        }
    }
}

