/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PopupItem;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public abstract class BasePopupView
extends LinearLayout {
    private static final int MAX_POPUP_WIDTH = 534;
    protected Context context;
    protected View root;
    protected ImageView buttonPopupClose;
    protected AvatarLayout avatarPopup;
    protected TextView textPopupBotName;
    protected TextView textPopupTime;
    protected TextView textPopupTitle;
    protected TextView textPopupMessage;
    protected ViewGroup layoutPopupContent;

    public BasePopupView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int popupWidth;
        int maxPopupWidth = (int)Utils.dpToPx(534.0f);
        if (maxPopupWidth < (popupWidth = View.MeasureSpec.getSize((int)widthMeasureSpec))) {
            popupWidth = maxPopupWidth;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)popupWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Initializer
    protected void init(Context context) {
        this.context = context;
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_popup, (ViewGroup)this, true);
        this.root.setVisibility(8);
        this.buttonPopupClose = (ImageView)this.root.findViewById(R.id.ch_button_popup_close);
        this.avatarPopup = (AvatarLayout)this.root.findViewById(R.id.ch_avatar_popup);
        this.textPopupBotName = (TextView)this.root.findViewById(R.id.ch_text_popup_bot_name);
        this.textPopupTime = (TextView)this.root.findViewById(R.id.ch_text_popup_time);
        this.textPopupTitle = (TextView)this.root.findViewById(R.id.ch_text_popup_title);
        this.textPopupMessage = (TextView)this.root.findViewById(R.id.ch_text_popup_message);
        this.layoutPopupContent = (ViewGroup)this.root.findViewById(R.id.ch_layout_popup_content);
        this.buttonPopupClose.setOnClickListener(v -> this.requestHide());
    }

    protected void bindPopupData(@NonNull PopupItem popupItem) {
        this.resetPopupContent();
        ProfileEntity person = popupItem.getProfile();
        this.avatarPopup.set(person);
        this.textPopupBotName.setText((CharSequence)(person != null ? person.getName() : ResUtils.getUnknown()));
        this.textPopupTime.setText((CharSequence)TimeUtils.getTime(popupItem.getCreatedAt()));
        Views.setVisibility((View)this.textPopupTitle, popupItem.getTitle() != null);
        this.textPopupTitle.setText((CharSequence)popupItem.getTitle());
        this.textPopupMessage.setText((CharSequence)popupItem.getFormattedSpanMessage());
        if (PrefSupervisor.isEnabledPushAlarm(this.context)) {
            AlarmCenter.alarm(this.context);
        }
    }

    protected abstract void requestHide();

    public void hideView() {
        this.root.setVisibility(8);
    }

    private void resetPopupContent() {
        for (int i = 0; i < this.layoutPopupContent.getChildCount(); ++i) {
            this.layoutPopupContent.getChildAt(i).setVisibility(8);
        }
    }
}

