/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format.message;

import android.support.v4.util.Pair;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.util.RegexUtils;
import com.zoyi.channel.plugin.android.util.message_format.message.EscapeMessage;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import java.util.regex.Pattern;

public class UnescapeMessage
implements MessagePattern {
    private Pattern unescapePattern = Pattern.compile(EscapeMessage.ESCAPE_PREFIX + "[\\d]+" + EscapeMessage.ESCAPE_POSTFIX);

    @Override
    public SpannableStringBuilder parse(SpannableStringBuilder span) {
        String plainText = span.toString();
        for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(this.unescapePattern.matcher((CharSequence)span))) {
            int start = (Integer)range.first;
            int end = (Integer)range.second;
            String escape = this.asciiToString(plainText.substring(start + EscapeMessage.ESCAPE_PREFIX.length(), end - EscapeMessage.ESCAPE_POSTFIX.length()));
            span.delete(start, end);
            span.insert(start, (CharSequence)escape);
        }
        return span;
    }

    private String asciiToString(String ascii) {
        int asciiNum = Integer.decode(ascii);
        String asciiChar = Character.toString((char)asciiNum);
        return asciiChar;
    }
}

