/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.model.wrapper.GuestWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GuestAction {
    public static void touch() {
        Api.touch().runBy(ActionType.TOUCH).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN).run(new RestSubscriber<GuestWrapper>(){

            @Override
            public void onSuccess(@NonNull GuestWrapper repo) {
                if (repo.getGuest() != null) {
                    GuestStore.get().guest.set(repo.getGuest());
                }
            }
        });
    }

    public static void updateProfileBot(@Nullable String messageId, final Action1<MessageWrapper> onSuccess, final Action0 onFail) {
        final String key = ProfileBotStore.get().inputKey.get();
        Object value = ProfileBotStore.get().inputValue.get();
        RestSubscriber<MessageWrapper> subscriber = new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (onFail != null) {
                    onFail.call();
                }
            }

            @Override
            public void onSuccess(@NonNull MessageWrapper repo) {
                if (onSuccess != null) {
                    onSuccess.call((Object)repo);
                }
                if (repo.getMessage() != null && repo.getMessage().getProfileBot() != null) {
                    for (ProfileBot profileBot : repo.getMessage().getProfileBot()) {
                        if (!CompareUtils.isSame(profileBot.getKey(), key)) continue;
                        GuestAction.handleGuestProfileUpdate(key, profileBot.getValue());
                    }
                }
            }
        };
        if (messageId != null && key != null && value != null) {
            if (value instanceof MobileNumber) {
                MobileNumber mobileNumber = (MobileNumber)value;
                Api.updateProfileBot(messageId, RequestUtils.form().set(key, String.format(Locale.US, "+%d%s", mobileNumber.getCountryCode(), mobileNumber.getPhoneNumber())).create()).runBy(ActionType.UPDATE_GUEST_PROFILE_BOT).cancelBy(ActionType.SHUTDOWN).run(subscriber);
            } else {
                Api.updateProfileBot(messageId, RequestUtils.form().set(key, value).create()).runBy(ActionType.UPDATE_GUEST_PROFILE_BOT).cancelBy(ActionType.SHUTDOWN).run(subscriber);
            }
        }
    }

    public static void updateGuestProfile(@Nullable String key, @Nullable String value, boolean isNumeric, Action0 onSuccess, Action1<String> onFail) {
        if (key != null) {
            HashMap<String, Object> profileMap = new HashMap<String, Object>();
            try {
                if (value == null || !isNumeric) {
                    profileMap.put(key, value);
                } else {
                    profileMap.put(key, Double.valueOf(value));
                }
            }
            catch (Exception ex) {
                profileMap.put(key, value);
            }
            GuestAction.updateGuest(profileMap, (Action1<Guest>)((Action1)guest -> {
                onSuccess.call();
                if (guest != null) {
                    GuestAction.handleGuestProfileUpdate(key, guest.getProfileValue(key));
                }
            }), onFail);
        } else {
            onFail.call(null);
        }
    }

    public static void updateGuest(Map<String, Object> profileMap, final @Nullable Action1<Guest> onSuccess, final @Nullable Action1<String> onFail) {
        Api.updateGuest(RequestUtils.form(profileMap, true).create()).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<GuestWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                if (onFail != null) {
                    onFail.call((Object)error.getMessage());
                }
            }

            @Override
            public void onSuccess(@NonNull GuestWrapper repo) {
                GuestStore.get().guest.set(repo.getGuest());
                if (onSuccess != null) {
                    onSuccess.call((Object)repo.getGuest());
                }
            }
        });
    }

    private static void handleGuestProfileUpdate(@Nullable String key, @Nullable Object value) {
        ChannelPluginListener listener = ChannelIO.getChannelPluginListener();
        if (key != null && listener != null) {
            listener.onChangeGuestProfile(key, value);
        }
    }
}

