/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.Properties;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.Timer;
import com.splunk.mint.network.io.InputStreamMonitor;
import com.splunk.mint.network.io.InputStreamMonitorKitKat;
import com.splunk.mint.network.io.OutputStreamMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public final class MonitorableHttpURLConnection
extends HttpURLConnection {
    private URLConnection original;
    private final MonitorRegistry registry;
    private final Timer timer;
    private final String connectionName;
    private InputStreamMonitor mInputStreamMonitor = null;
    private OutputStreamMonitor mOutputStreamMonitor = null;
    private InputStreamMonitorKitKat mInputStreamMonitorKitKat = null;

    public MonitorableHttpURLConnection(MonitorRegistry registry, URLConnection original) {
        super(original.getURL());
        this.registry = registry;
        this.original = original;
        this.connectionName = this.url.toString();
        this.timer = new Timer(this.connectionName);
        NetLogManager.getInstance().startNetworkCall(original.getURL().toExternalForm(), original.getURL().toExternalForm(), System.currentTimeMillis(), "HTTP");
    }

    @Override
    public void connect() throws IOException {
        try {
            this.timer.start();
            this.original.connect();
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    @Override
    public void disconnect() {
        int statusCode = NetLogManager.getStatusCodeFromURLConnection(this.original);
        NetLogManager.getInstance().endNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), statusCode);
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).disconnect();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            if (Properties.isKitKat) {
                if (this.mInputStreamMonitorKitKat == null) {
                    this.mInputStreamMonitorKitKat = new InputStreamMonitorKitKat(this.original.getURL().toString() + "-in", this.registry, this.original.getInputStream(), null);
                }
                return this.mInputStreamMonitorKitKat;
            }
            if (this.mInputStreamMonitor == null) {
                this.mInputStreamMonitor = new InputStreamMonitor(this.original.getURL().toString() + "-in", this.registry, this.original.getInputStream(), null);
            }
            return this.mInputStreamMonitor;
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        try {
            if (this.mOutputStreamMonitor == null) {
                this.mOutputStreamMonitor = new OutputStreamMonitor(this.original.getURL().toString() + "-out", this.registry, this.original.getOutputStream());
            }
            return this.mOutputStreamMonitor;
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.original.getAllowUserInteraction();
    }

    @Override
    public void addRequestProperty(String field, String newValue) {
        this.original.addRequestProperty(field, newValue);
    }

    @Override
    public int getConnectTimeout() {
        return this.original.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        try {
            return this.original.getContent();
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    public Object getContent(Class[] types) throws IOException {
        try {
            return this.original.getContent(types);
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    @Override
    public String getContentEncoding() {
        return this.original.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this.original.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.original.getContentType();
    }

    @Override
    public long getDate() {
        return this.original.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.original.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this.original.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.original.getDoOutput();
    }

    @Override
    public long getExpiration() {
        return this.original.getExpiration();
    }

    @Override
    public String getHeaderField(int pos) {
        return this.original.getHeaderField(pos);
    }

    @Override
    public String getHeaderField(String key) {
        return this.original.getHeaderField(key);
    }

    @Override
    public long getHeaderFieldDate(String field, long defaultValue) {
        return this.original.getHeaderFieldDate(field, defaultValue);
    }

    @Override
    public int getHeaderFieldInt(String field, int defaultValue) {
        return this.original.getHeaderFieldInt(field, defaultValue);
    }

    @Override
    public String getHeaderFieldKey(int posn) {
        return this.original.getHeaderFieldKey(posn);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.original.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this.original.getIfModifiedSince();
    }

    @Override
    public long getLastModified() {
        return this.original.getLastModified();
    }

    @Override
    public Permission getPermission() throws IOException {
        try {
            return this.original.getPermission();
        }
        catch (IOException e) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", e.getMessage());
            throw e;
        }
    }

    @Override
    public int getReadTimeout() {
        return this.original.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.original.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String field) {
        return this.original.getRequestProperty(field);
    }

    @Override
    public URL getURL() {
        return this.original.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.original.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean newValue) {
        this.original.setAllowUserInteraction(newValue);
    }

    @Override
    public void setConnectTimeout(int timeoutMillis) {
        this.original.setConnectTimeout(timeoutMillis);
    }

    @Override
    public void setDefaultUseCaches(boolean newValue) {
        this.original.setDefaultUseCaches(newValue);
    }

    @Override
    public void setDoInput(boolean newValue) {
        this.original.setDoInput(newValue);
    }

    @Override
    public void setDoOutput(boolean newValue) {
        this.original.setDoOutput(newValue);
    }

    @Override
    public void setIfModifiedSince(long newValue) {
        this.original.setIfModifiedSince(newValue);
    }

    @Override
    public void setReadTimeout(int timeoutMillis) {
        this.original.setReadTimeout(timeoutMillis);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        this.original.setRequestProperty(field, newValue);
    }

    @Override
    public void setUseCaches(boolean newValue) {
        this.original.setUseCaches(newValue);
    }

    @Override
    public boolean usingProxy() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).usingProxy();
        }
        return false;
    }

    @Override
    public InputStream getErrorStream() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getErrorStream();
        }
        return null;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getInstanceFollowRedirects();
        }
        return true;
    }

    @Override
    public String getRequestMethod() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getRequestMethod();
        }
        return "GET";
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getResponseCode();
        }
        return -1;
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getResponseMessage();
        }
        return "";
    }

    @Override
    public void setChunkedStreamingMode(int chunkLength) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setChunkedStreamingMode(chunkLength);
        }
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setFixedLengthStreamingMode(contentLength);
        }
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setInstanceFollowRedirects(followRedirects);
        }
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setRequestMethod(method);
        }
    }
}

