/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.scrollview;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.view.scrollview.OnScrollableStateChangeListener;

public abstract class BottomPlaceholderLayout<E extends ViewGroup>
extends LinearLayout {
    @Nullable
    private E scrollableViewGroup;
    private int height = 0;
    private int basePaddingBottom = 0;
    private boolean stackFromEnd = false;
    @Nullable
    private OnScrollableStateChangeListener onScrollableStateChangeListener;

    public BottomPlaceholderLayout(Context context) {
        super(context);
    }

    public BottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = h;
        this.handleScrollableViewPadding(this.scrollableViewGroup);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.handleScrollableViewPadding(this.scrollableViewGroup);
    }

    protected void setScrollableView(@Nullable E scrollableViewGroup, @Nullable OnScrollableStateChangeListener onScrollableStateChangeListener) {
        if (this.scrollableViewGroup == null && scrollableViewGroup != null) {
            this.scrollableViewGroup = scrollableViewGroup;
            this.scrollableViewGroup.setClipToPadding(false);
            this.scrollableViewGroup.addOnLayoutChangeListener((v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> this.handleScrollableState(this.canScroll((ViewGroup)v, bottom - top)));
            this.onScrollableStateChangeListener = onScrollableStateChangeListener;
        }
    }

    public void setStackFromEnd(boolean stackFromEnd) {
        this.stackFromEnd = stackFromEnd;
    }

    protected abstract boolean canScroll(E var1, int var2);

    protected abstract boolean isOnBottom(E var1);

    protected abstract void scrollToBottom(E var1);

    private void handleScrollableViewPadding(@Nullable E view) {
        if (view != null) {
            boolean isOnBottom = this.isOnBottom(view);
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), this.height + this.basePaddingBottom);
            if (this.stackFromEnd && isOnBottom) {
                this.scrollToBottom(view);
            }
        }
    }

    private void handleScrollableState(boolean scrollable) {
        if (this.onScrollableStateChangeListener != null) {
            this.onScrollableStateChangeListener.OnScrollableStateChange(scrollable);
        }
    }

    public void setBasePaddingBottom(int basePaddingBottom) {
        this.basePaddingBottom = basePaddingBottom;
        this.handleScrollableViewPadding(this.scrollableViewGroup);
    }
}

