/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.message_format.message;

import android.content.Context;
import android.support.v4.util.Pair;
import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.util.AssetUtils;
import com.zoyi.channel.plugin.android.util.RegexUtils;
import com.zoyi.channel.plugin.android.util.message_format.message.MessagePattern;
import java.util.regex.Pattern;

public class EmojiMessage
implements MessagePattern {
    private Pattern emojiPattern = Pattern.compile("(:)([a-zA-Z0-9_+-]+?)\\1");
    private Context context;

    public EmojiMessage(Context context) {
        this.context = context;
    }

    @Override
    public SpannableStringBuilder parse(SpannableStringBuilder span) {
        for (Pair<Integer, Integer> range : RegexUtils.getReversedRange(this.emojiPattern.matcher((CharSequence)span))) {
            int start = (Integer)range.first;
            int end = (Integer)range.second;
            String emojiKey = span.toString().substring(start + 1, end - 1);
            if (AssetUtils.getEmoji(this.context, emojiKey) == null) continue;
            span.delete(start, end);
            span.insert(start, (CharSequence)AssetUtils.getEmoji(this.context, emojiKey));
        }
        return span;
    }
}

