package com.zoyi.channel.plugin.android.selector2;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.*;
import com.zoyi.channel.plugin.android.store2.binder.*;
import com.zoyi.channel.plugin.android.store2.state.*;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatSelector {

  public static Binder bindWelcomeMessage(Action3<FetchState, SupportBotEntry, String> action3) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<FetchState> pluginFetchState = PluginStore.get().pluginFetchState;

    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
    State<FetchState> supportBotFetchState = SupportBotStore.get().supportBotFetchState;

    EnumState<CHLocale> localeState = SettingsStore.get().locale;

    State<Guest> guestState = GuestStore.get().guest;

    return new Binder6<>(
        pluginState,
        pluginFetchState,
        supportBotState,
        supportBotFetchState,
        localeState,
        guestState
    ).bind((plugin, pluginFetch, supportBotEntry, supportBotFetch, locale, guest) -> {
      if (supportBotFetch != FetchState.COMPLETE) {
        action3.call(supportBotFetch, null, null);
        return;
      }
      if (supportBotEntry != null) {
        action3.call(FetchState.COMPLETE, supportBotEntry, null);
        return;
      }
      if (pluginFetch != FetchState.COMPLETE) {
        action3.call(pluginFetch, null, null);
        return;
      }
      if (plugin != null && guest != null) {
        action3.call(FetchState.COMPLETE, null, MessageUtils.createWelcomeMessage(plugin, guest, locale));
        return;
      }
      action3.call(FetchState.FAILED, null, null);
    });
  }

  public static Binder bindChat(@Nullable String chatId, Action3<UserChat, Boolean, Boolean> action3) {
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    State<Channel> channelState = ChannelStore.get().channelState;
    BooleanState typingState = TypingStore.get().typingState;
    State<Long> nowState = TimerStore.get().now;
    BooleanState temporaryInputOpenedState = ChatStore.get().temporaryInputOpenedState;

    return new Binder5<>(userChatsState, channelState, typingState, nowState, temporaryInputOpenedState).bind(
        (userChats, channel, isTyping, now, temporaryInputOpened) -> {
          if (userChats.containsKey(chatId) && userChats.get(chatId) != null) {
            action3.call(
                userChats.get(chatId),
                ChannelSelector.shouldAcceptAction(channel, now, isTyping),
                temporaryInputOpened
            );
          }
        });
  }

  public static Binder bindTyping(Action1<Boolean> action1) {
    EnumState<SocketStatus> socketStatusState = SocketStore.get().socketState;
    ExpirableEntityMapState<Typing> myTypingState = TypingStore.get().myTypingState;

    return new Binder2<>(socketStatusState, myTypingState).bind((socketStatus, myTyping) -> {
      if (socketStatus == SocketStatus.READY) {
        action1.call(myTyping != null && myTyping.size() > 0);
      }
    });
  }

  public static Binder bindHostTyping(String chatId, Action1<List<Typing>> action1) {
    ExpirableEntityMapState<Typing> hostTypingState = TypingStore.get().hostTypingState;

    return new Binder1<>(hostTypingState).bind(typingMap -> {
      List<Typing> typings = new ArrayList<>();

      for (Typing typing : typingMap.values()) {
        if (typing != null && typing.getChatId() != null && typing.getChatId().equals(chatId)) {
          typings.add(typing);
        }
      }

      Collections.sort(typings, (o1, o2) -> CompareUtils.compare(o1.getCreatedAt(), o2.getCreatedAt()));

      action1.call(typings);
    });
  }
}
