package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.selector2.PushBotSelector;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.popup.InAppPushView;
import com.zoyi.channel.plugin.android.view.popup.PushBotPopupView;

/**
 * Control launcher, popup
 */
class ChannelView extends FrameLayout implements OnPushBotClickListener {

  private Context context;

  private ChannelLauncherView launcherView;
  private InAppPushView inAppPushView;
  private PushBotPopupView pushBotPopupView;

  @Nullable
  private Binder visibilityBinder;

  @Nullable
  private Binder launcherVisibilityBinder;

  @Nullable
  private Binder pushBotBinder;

  @Nullable
  private Binder inAppPushBinder;

  public ChannelView(Context context) {
    super(context);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_channel_view, this, true);

    launcherView = view.findViewById(R.id.ch_view_launcher);
    inAppPushView = view.findViewById(R.id.ch_view_in_app_push);
    pushBotPopupView = view.findViewById(R.id.ch_view_push_bot_popup);
    pushBotPopupView.setPushBotClickListener(this);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    visibilityBinder = GlobalSelector.bindBootState(booted -> setVisibility(booted ? View.VISIBLE : View.GONE));

    launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility(showLauncher -> {
      if (showLauncher) {
        launcherView.show();
      } else {
        launcherView.hide();
      }
    });

    pushBotBinder = PushBotSelector.bindPopupPushBot(context, pushBotItem -> {
      if (pushBotItem != null) {
        pushBotPopupView.show(pushBotItem);
      } else {
        pushBotPopupView.hideView();
      }
    });

    inAppPushBinder = GlobalSelector.bindInAppPush(inAppPushItem -> {
      if (inAppPushItem != null) {
        inAppPushView.show(inAppPushItem);
      } else {
        inAppPushView.hideView();
      }
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (visibilityBinder != null) {
      visibilityBinder.unbind();
    }

    if (launcherVisibilityBinder != null) {
      launcherVisibilityBinder.unbind();
    }

    if (pushBotBinder != null) {
      pushBotBinder.unbind();
    }

    if (inAppPushBinder != null) {
      inAppPushBinder.unbind();
    }
  }

  @Override
  public void onPushBotClick(@NonNull String pushBotId) {
    startPushBotChat(pushBotId);
  }

  @Override
  public void onPushBotContentsClick(@NonNull String pushBotId, @Nullable String redirectUrl) {
    if (redirectUrl != null) {
      Executor.executeRedirectUrlAction(context, redirectUrl);
    } else {
      startPushBotChat(pushBotId);
    }
  }

  private void startPushBotChat(@NonNull String pushBotId) {
    IntentUtils.setNextActivity(context, LoungeActivity.class)
        .setTransition(Transition.SLIDE_FROM_BOTTOM)
        .putExtra(Const.EXTRA_CHAT_CONTENT_TYPE, ChatContentType.PUSH_BOT_CHAT.toString())
        .putExtra(Const.EXTRA_CHAT_CONTENT_ID, pushBotId)
        .startActivity();
  }
}
