/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WorkingTime {
    private TimeRange sun;
    private TimeRange mon;
    private TimeRange tue;
    private TimeRange wed;
    private TimeRange thu;
    private TimeRange fri;
    private TimeRange sat;

    public String getMessage(Context context) {
        ArrayList<String> list = new ArrayList<String>();
        this.addTimeRange(context, list, "sun", this.sun);
        this.addTimeRange(context, list, "mon", this.mon);
        this.addTimeRange(context, list, "tue", this.tue);
        this.addTimeRange(context, list, "wed", this.wed);
        this.addTimeRange(context, list, "thu", this.thu);
        this.addTimeRange(context, list, "fri", this.fri);
        this.addTimeRange(context, list, "sat", this.sat);
        return StringUtils.join(list, "\n\n");
    }

    private List<TimeRange> getTimeRanges() {
        return Arrays.asList(this.sun, this.mon, this.tue, this.wed, this.thu, this.fri, this.sat);
    }

    public boolean isValid() {
        for (TimeRange timeRange : this.getTimeRanges()) {
            if (timeRange == null || !timeRange.isValid()) continue;
            return true;
        }
        return false;
    }

    public TimeRange getWeekdayTimeRange(int weekDay) {
        switch (weekDay) {
            case 1: {
                return this.sun;
            }
            case 2: {
                return this.mon;
            }
            case 3: {
                return this.tue;
            }
            case 4: {
                return this.wed;
            }
            case 5: {
                return this.thu;
            }
            case 6: {
                return this.fri;
            }
            case 7: {
                return this.sat;
            }
        }
        return null;
    }

    private void addTimeRange(Context context, List<String> list, String key, TimeRange timeRange) {
        if (timeRange == null || timeRange.getFrom() == null || timeRange.getTo() == null) {
            return;
        }
        String title = ResUtils.getString(context, "ch.out_of_work." + key);
        String content = TimeUtils.getTimeRangeString(timeRange);
        list.add(String.format("%s: %s", title, content));
    }
}

