package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.GuestAction;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.selector2.GuestSelector;
import com.zoyi.channel.plugin.android.selector2.SocketSelector;
import com.zoyi.channel.plugin.android.store2.TimerStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;

import java.util.concurrent.TimeUnit;

public class ChannelActionHandler {

  @Nullable
  private ChannelPluginListener listener;

  @Nullable
  private Binder socketBinder;

  @Nullable
  private Binder countHandler;

  @Nullable
  private Binder inAppPushHandler;

  @Nullable
  private Subscription workingTimer;

  public void handle() {
    socketBinder = SocketSelector.bindSocket(socketStatus -> {
      if (socketStatus == SocketStatus.READY) {
        GuestAction.touch();
      }
    });

    countHandler = GuestSelector.bindGuestAlertCount(count -> {
      if (listener != null && count != null) {
        listener.onChangeBadge(count);
      }
    });

    inAppPushHandler = GlobalSelector.bindInAppPush(inAppPushItem -> {
      if (listener != null && inAppPushItem != null) {
        listener.onReceivePush(new PushEvent(inAppPushItem));
      }
    });

    workingTimer = Observable.interval(60, TimeUnit.SECONDS)
        .onBackpressureBuffer()
        .subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(l -> TimerStore.get().now.set(TimeUtils.getCurrentTime()));

    TimerStore.get().now.set(TimeUtils.getCurrentTime());
  }

  public void unHandle() {
    if (socketBinder != null) {
      socketBinder.unbind();
      socketBinder = null;
    }

    if (countHandler != null) {
      countHandler.unbind();
      countHandler = null;
    }

    if (inAppPushHandler != null) {
      inAppPushHandler.unbind();
      inAppPushHandler = null;
    }

    if (workingTimer != null) {
      if (!workingTimer.isUnsubscribed()) {
        workingTimer.unsubscribe();
      }
      workingTimer = null;
    }
  }

  @Nullable
  public ChannelPluginListener getListener() {
    return listener;
  }

  public void setListener(@Nullable ChannelPluginListener listener) {
    this.listener = listener;
  }

  public void clearListener() {
    this.listener = null;
  }
}
