/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.etc.InAppPushItem;
import com.zoyi.channel.plugin.android.push_bot.OnPushBotClickListener;
import com.zoyi.channel.plugin.android.selector2.GlobalSelector;
import com.zoyi.channel.plugin.android.selector2.PushBotSelector;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.view.popup.InAppPushView;
import com.zoyi.channel.plugin.android.view.popup.PushBotPopupView;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPushBotClickListener {
    private Context context;
    private ChannelLauncherView launcherView;
    private InAppPushView inAppPushView;
    private PushBotPopupView pushBotPopupView;
    @Nullable
    private Binder visibilityBinder;
    @Nullable
    private Binder launcherVisibilityBinder;
    @Nullable
    private Binder pushBotBinder;
    @Nullable
    private Binder inAppPushBinder;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.launcherView = (ChannelLauncherView)view.findViewById(R.id.ch_view_launcher);
        this.inAppPushView = (InAppPushView)view.findViewById(R.id.ch_view_in_app_push);
        this.pushBotPopupView = (PushBotPopupView)view.findViewById(R.id.ch_view_push_bot_popup);
        this.pushBotPopupView.setPushBotClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.visibilityBinder = GlobalSelector.bindBootState((Action1<Boolean>)((Action1)booted -> this.setVisibility(booted != false ? 0 : 8)));
        this.launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility((Action1<Boolean>)((Action1)showLauncher -> {
            if (showLauncher.booleanValue()) {
                this.launcherView.show();
            } else {
                this.launcherView.hide();
            }
        }));
        this.pushBotBinder = PushBotSelector.bindPopupPushBot(this.context, (Action1<PushBotItem>)((Action1)pushBotItem -> {
            if (pushBotItem != null) {
                this.pushBotPopupView.show((PushBotItem)pushBotItem);
            } else {
                this.pushBotPopupView.hideView();
            }
        }));
        this.inAppPushBinder = GlobalSelector.bindInAppPush((Action1<InAppPushItem>)((Action1)inAppPushItem -> {
            if (inAppPushItem != null) {
                this.inAppPushView.show((InAppPushItem)inAppPushItem);
            } else {
                this.inAppPushView.hideView();
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.visibilityBinder != null) {
            this.visibilityBinder.unbind();
        }
        if (this.launcherVisibilityBinder != null) {
            this.launcherVisibilityBinder.unbind();
        }
        if (this.pushBotBinder != null) {
            this.pushBotBinder.unbind();
        }
        if (this.inAppPushBinder != null) {
            this.inAppPushBinder.unbind();
        }
    }

    @Override
    public void onPushBotClick(@NonNull String pushBotId) {
        this.startPushBotChat(pushBotId);
    }

    @Override
    public void onPushBotContentsClick(@NonNull String pushBotId, @Nullable String redirectUrl) {
        if (redirectUrl != null) {
            Executor.executeRedirectUrlAction(this.context, redirectUrl);
        } else {
            this.startPushBotChat(pushBotId);
        }
    }

    private void startPushBotChat(@NonNull String pushBotId) {
        IntentUtils.setNextActivity(this.context, LoungeActivity.class).setTransition(Transition.SLIDE_FROM_BOTTOM).putExtra("chatContentType", ChatContentType.PUSH_BOT_CHAT.toString()).putExtra("chatContentId", pushBotId).startActivity();
    }
}

