package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector2.StyleSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.util.message_format.CustomMovementMethod;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

import static com.zoyi.channel.plugin.android.activity.chat.type.MessageType.GUEST;
import static com.zoyi.channel.plugin.android.activity.chat.type.MessageType.HOST;

/**
 * Created by jerry on 2018. 3. 30..
 */

public abstract class TextMessageHolder extends BaseMessageHolder {

  @Nullable
  private LinearLayout rootGuestMessageText;
  @Nullable
  private MaskableFrameLayout frameGuestMessageEdgeHead;
  @Nullable
  private MaskableFrameLayout frameGuestMessageCircleHead;
  @Nullable
  private TextView textGuestMessage;
  @Nullable
  private View viewGuestMessageEdgeHeadBackground;
  @Nullable
  private View viewGuestMessageCircleHeadBackground;

  @Nullable
  private LinearLayout rootHostMessageText;
  @Nullable
  private View frameHostMessageEdgeHead;
  @Nullable
  private View frameHostMessageCircleHead;
  @Nullable
  private TextView textHostMessage;

  private TextView textContentMessageGiantEmoji;

  protected TextMessageHolder(View itemView, MessageType messageType) {
    super(itemView, messageType);

    switch (messageType) {
      case GUEST:
      case SENDING:
        rootGuestMessageText = itemView.findViewById(R.id.ch_root_guest_message_text);
        frameGuestMessageEdgeHead = itemView.findViewById(R.id.ch_frame_guest_message_edge_head);
        frameGuestMessageCircleHead = itemView.findViewById(R.id.ch_frame_guest_message_circle_head);
        textGuestMessage = itemView.findViewById(R.id.ch_text_guest_message);
        viewGuestMessageEdgeHeadBackground = itemView.findViewById(R.id.ch_view_guest_message_edge_head);
        viewGuestMessageCircleHeadBackground = itemView.findViewById(R.id.ch_view_guest_message_circle_head);
        break;

      default:
        rootHostMessageText = itemView.findViewById(R.id.ch_root_host_message_text);
        frameHostMessageEdgeHead = itemView.findViewById(R.id.ch_view_host_message_edge_head);
        frameHostMessageCircleHead = itemView.findViewById(R.id.ch_view_host_message_circle_head);
        textHostMessage = itemView.findViewById(R.id.ch_text_host_message);
        break;
    }

    textContentMessageGiantEmoji = itemView.findViewById(R.id.ch_text_message_content_giant_emoji);
  }

  protected void bind(@Nullable Message message, MessageType messageType, boolean isConnectedMessage) {
    super.bind(message, messageType, isConnectedMessage);

    if (message != null && message.getFormattedSpanMessage() != null && CompareUtils.exists(messageType, GUEST, HOST)) {
      SpannableStringBuilder formattedMessage = message.getFormattedSpanMessage();

      if (MessageUtils.hasOnlyEmoji(formattedMessage)) {
        setGiantEmoji(formattedMessage);
      } else if (messageType == GUEST) {
        setGuestMessageText(formattedMessage, isConnectedMessage);
      } else if (messageType == HOST) {
        setHostMessageText(formattedMessage, isConnectedMessage);
      }
    }
  }

  @Override
  protected void resetViews() {
    if (rootGuestMessageText != null) {
      rootGuestMessageText.setVisibility(View.GONE);
    }

    if (rootHostMessageText != null) {
      rootHostMessageText.setVisibility(View.GONE);
    }
  }

  protected void setGuestMessageText(CharSequence formattedMessage, boolean isConnectedMessage) {
    if (formattedMessage != null &&
        rootGuestMessageText != null &&
        frameGuestMessageEdgeHead != null &&
        frameGuestMessageCircleHead != null &&
        textGuestMessage != null &&
        viewGuestMessageEdgeHeadBackground != null &&
        viewGuestMessageCircleHeadBackground != null) {

      rootGuestMessageText.setVisibility(View.VISIBLE);
      Views.setVisibility(frameGuestMessageEdgeHead, !isConnectedMessage);
      Views.setVisibility(frameGuestMessageCircleHead, isConnectedMessage);

      viewGuestMessageEdgeHeadBackground.setBackgroundColor(StyleSelector.getBackColor());
      viewGuestMessageCircleHeadBackground.setBackgroundColor(StyleSelector.getBackColor());

      textGuestMessage.setBackgroundColor(StyleSelector.getBackColor());
      textGuestMessage.setMovementMethod(CustomMovementMethod.getInstance());
      textGuestMessage.setLinkTextColor(StyleSelector.getTextColor());
      textGuestMessage.setTextColor(StyleSelector.getTextColor());
      textGuestMessage.setText(formattedMessage);
    }
  }

  protected void setHostMessageText(CharSequence formattedMessage, boolean isConnectedMessage) {
    if (formattedMessage != null &&
        rootHostMessageText != null &&
        frameHostMessageEdgeHead != null &&
        frameHostMessageCircleHead != null &&
        textHostMessage != null) {

      rootHostMessageText.setVisibility(View.VISIBLE);
      Views.setVisibility(frameHostMessageEdgeHead, !isConnectedMessage);
      Views.setVisibility(frameHostMessageCircleHead, isConnectedMessage);

      textHostMessage.setMovementMethod(CustomMovementMethod.getInstance());
      textHostMessage.setText(formattedMessage);
    }
  }

  protected void setGiantEmoji(CharSequence formattedMessage) {
    if (textContentMessageGiantEmoji != null) {
      textContentMessageGiantEmoji.setVisibility(View.VISIBLE);
      textContentMessageGiantEmoji.setText(formattedMessage);
    }
  }
}
