package com.zoyi.channel.plugin.android.selector2;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.ManagerStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.binder.Binder2;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.rx.functions.Action1;

import java.util.Collection;

public class ProfileSelector {

  public static Binder2 bindDefaultProfile(Action1<ProfileEntity> action1) {
    State<String> defaultBotIdState = Store2.getInstance(BotStore.class).defaultBotId;
    EntityMapState<Bot> botsState = Store2.getInstance(BotStore.class).bots;
    State<Channel> channelState = Store2.getInstance(ChannelStore.class).channelState;

    return new Binder2<>(defaultBotIdState, channelState).bind((defaultBotId, channel) -> {
      if (defaultBotId != null) {
        Bot bot = botsState.get(defaultBotId);
        if (bot != null) {
          action1.call(bot);
          return;
        }
      }

      if (channel != null) {
        action1.call(channel);
      }
    });
  }

  @Nullable
  public static ProfileEntity getProfile(@Nullable String personType, @Nullable String personId) {
    State<Channel> channelState = ChannelStore.get().channelState;
    EntityMapState<Bot> botsState = BotStore.get().bots;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;

    if (personType == null) {
      return channelState.get();
    } else if (Const.MANAGER.equals(personType)) {
      return managersState.get(personId);
    } else if (Const.BOT.equals(personType)) {
      return botsState.get(personId);
    }
    return null;
  }
}
