package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class UserChatItem implements ChatItem {

  private UserChat userChat;
  @Nullable
  private Message message;
  @Nullable
  private Session session;
  @Nullable
  private ProfileEntity profileEntity;

  public UserChatItem(UserChat userChat, @Nullable Message message, @Nullable Session session, @Nullable ProfileEntity profileEntity) {
    this.userChat = userChat;
    this.message = message;
    this.session = session;
    this.profileEntity = profileEntity;
  }

  @Nullable
  @Override
  public String getId() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }

  @Nullable
  @Override
  public ProfileEntity getProfile() {
    if (profileEntity != null) {
      return profileEntity;
    }
    return ChannelStore.get().channelState.get();
  }

  @Nullable
  @Override
  public Long getUpdatedAt() {
    if (userChat != null && userChat.isStateClosed() && userChat.getClosedAt() != null) {
      return userChat.getClosedAt();
    }
    if (userChat != null && userChat.getUpdatedAt() != null) {
      return userChat.getUpdatedAt();
    }
    return null;
  }

  @NonNull
  @Override
  public String getMessage() {
    if (userChat != null && userChat.getReview() != null) {
      return ResUtils.getString("ch.review.complete.preview");
    } else {
      if (message != null) {
        if (message.getMessage() != null) {
          return message.getMessage();
        } else if (message.getFile() != null) {
          if (message.getFile().isImage()) {
            return ResUtils.getString("ch.notification.upload_image.description");
          } else {
            return ResUtils.getString("ch.notification.upload_file.description");
          }
        }
      }
    }
    return "";
  }

  @Override
  public boolean isActive() {
    if (userChat != null) {
      return userChat.getReview() == null && !userChat.isStateClosed();
    }
    return true;
  }

  @Override
  public int getCount() {
    if (session != null && session.getAlert() != null) {
      return session.getAlert();
    }
    return 0;
  }

  @Nullable
  @Override
  public String getSubKey() {
    if (userChat != null) {
      return userChat.getId();
    }
    return null;
  }

  @Override
  public ChatContentType getType() {
    return ChatContentType.USER_CHAT;
  }
}
