/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Single;
import com.zoyi.rx.SingleSubscriber;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SingleTakeUntilObservable<T, U>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Observable<? extends U> other;

    public SingleTakeUntilObservable(Single.OnSubscribe<T> source, Observable<? extends U> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        TakeUntilSourceSubscriber parent = new TakeUntilSourceSubscriber(t);
        t.add(parent);
        this.other.subscribe(parent.other);
        this.source.call(parent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TakeUntilSourceSubscriber<T, U>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;
        final Subscriber<U> other;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
            this.other = new OtherSubscriber();
            this.add(this.other);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error);
            } else {
                RxJavaHooks.onError(error);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class OtherSubscriber
        extends Subscriber<U> {
            OtherSubscriber() {
            }

            @Override
            public void onNext(U value) {
                this.onCompleted();
            }

            @Override
            public void onError(Throwable error) {
                TakeUntilSourceSubscriber.this.onError(error);
            }

            @Override
            public void onCompleted() {
                this.onError(new CancellationException("Single::takeUntil(Observable) - Stream was canceled before emitting a terminal event."));
            }
        }
    }
}

