package com.zoyi.channel.plugin.android.store;

import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.StoreType;

/**
 * Created by jerry on 2018. 9. 6..
 */

public class UiStateStore extends Store implements DestroyableStore {

  private boolean launcherVisible = false;
  private boolean closedChatVisible = false;

  public void setLauncherVisible(boolean visible) {
    this.launcherVisible = visible;
  }

  public boolean getLauncherVisible() {
    return launcherVisible;
  }

  public boolean shouldShowClosedChat() {
    return closedChatVisible;
  }

  public void setClosedChatVisible(boolean closedChatVisible) {
    this.closedChatVisible = closedChatVisible;
  }

  @NonNull
  @Override
  protected StoreType getStoreType() {
    return StoreType.GLOBAL_VIEW;
  }


  @Override
  public void clearData() {
    // launcherVisible, closedChatVisible shouldn't reset.
  }
}
